/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.control;

import oracle.bpm.designer.collaboration.control.CollaborationEntityController;
import oracle.bpm.designer.collaboration.control.DragCollaborationEntityCapability;
import oracle.bpm.designer.collaboration.control.PopUpCollaborationEntityCapability;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationEntity;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationProcess;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationService;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationUniverse;
import oracle.bpm.designer.controller.BpmnControllerFactory;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerCreator;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.CapableControllerImpl;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.diagram.editor.capability.selection.ElementSelectionCapability;
import oracle.bpm.project.model.collaboration.CollaborationEntity;
import oracle.bpm.project.model.collaboration.CollaborationUniverse;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class CollaborationControllerFactory
extends BpmnControllerFactory {
    private static CollaborationControllerFactory instance;

    public static CollaborationControllerFactory getInstance() {
        if (instance == null) {
            instance = new CollaborationControllerFactory();
        }
        return instance;
    }

    @Override
    protected void creators() {
        this.creator(this.collaborationUniverseCreator());
        this.creator(this.collaborationServiceCreator());
        this.creator(this.collaborationProcessCreator());
        this.creator(this.processCreator());
        super.creators();
    }

    protected ControllerCreator collaborationProcessCreator() {
        return this.entityController(DrawableCollaborationProcess.class);
    }

    protected ControllerCreator collaborationServiceCreator() {
        return this.entityController(DrawableCollaborationService.class);
    }

    private <T extends DrawableCollaborationEntity<V>, V extends CollaborationEntity> ControllerCreator<T> entityController(Class<T> clazz) {
        return new ControllerCreator<T>(clazz){

            protected Controller create(@NotNull Controller container, @NotNull T drawable) {
                CollaborationEntityController controller = new CollaborationEntityController(container, drawable);
                controller.install((Capability)new FocusCapability(controller));
                controller.install((Capability)new ElementSelectionCapability(controller));
                controller.install((Capability)new DragCollaborationEntityCapability(controller));
                controller.install(new PopUpCollaborationEntityCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator collaborationUniverseCreator() {
        return new ControllerCreator<DrawableCollaborationUniverse>(DrawableCollaborationUniverse.class){

            protected Controller create(@NotNull Controller container, @NotNull DrawableCollaborationUniverse drawable) {
                CapableControllerImpl<CollaborationUniverse> controller = new CapableControllerImpl<CollaborationUniverse>(container, (Drawable)drawable){

                    @NotNull
                    public Cursor getCursor() {
                        return Cursor.DEFAULT_CURSOR;
                    }
                };
                controller.install((Capability)new FocusCapability((CapableController)controller));
                controller.install((Capability)new ElementSelectionCapability((CapableController)controller));
                return controller;
            }
        };
    }
}

