/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration;

import oracle.bpm.command.Command;
import oracle.bpm.designer.collaboration.CollaborationDomain;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.DomainStateManager;
import org.jetbrains.annotations.NotNull;

public class CollaborationStateManager
extends DomainStateManager {
    private static final float MIN_SCALE = 0.3f;
    private static final float MAX_SCALE = 1.6f;
    private static final float INC_SCALE = 0.1f;

    public CollaborationStateManager(@NotNull CollaborationDomain domain) {
        super((Domain)domain);
    }

    public float zoomOut() {
        CollaborationDomain domain = this.getDomain();
        float scale = domain.getContext().getScale();
        scale = scale < 1.6f ? Math.min(scale + 0.1f, 1.6f) : 1.6f;
        domain.getContext().setScale(scale);
        domain.getCanvas().resetSize();
        domain.getCanvas().repaint();
        return scale;
    }

    public float zoomIn() {
        CollaborationDomain domain = this.getDomain();
        float scale = domain.getContext().getScale();
        scale = scale > 0.3f ? Math.max(scale - 0.1f, 0.3f) : 0.3f;
        domain.getContext().setScale(scale);
        domain.getCanvas().resetSize();
        domain.getCanvas().revalidate();
        return scale;
    }

    public void deletePressed() {
    }

    public void scaleChanged() {
    }

    public void runCommand(@NotNull Command command) {
    }

    public boolean isSimulating() {
        return false;
    }

    public CollaborationDomain getDomain() {
        return (CollaborationDomain)super.getDomain();
    }
}

