/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration;

import java.awt.Component;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.collaboration.CollaborationCanvas;
import oracle.bpm.designer.collaboration.CollaborationDomain;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.toolbar.ScaleTool;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.draw.collaboration.CollaborationUniverseImpl;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.collaboration.CollaborationUniverse;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class CollaborationProcessEditor
extends AbstractEditor<CollaborationUniverse> {
    private Panel container;
    private CollaborationDomain domain;
    private ScaleTool scaleTool;
    private Panel splitContainer;
    private ToolBar toolbar;

    public CollaborationProcessEditor(UiContainer parent, Process process) {
        super(parent, CollaborationUniverseImpl.create((Process)process), CollaborationUniverse.class);
        this.setInsets(new Margin(0, 0, 0, 0));
        this.setPanelId(ModelUtils.getModelTitle((Process)process));
    }

    @Override
    public void disposeEditor() {
        super.disposeEditor();
    }

    @Override
    public void openPart(Object part) {
        if (part instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)part;
            FlowElementController controller = this.getControllerFor(flowElement);
            this.scrollToCenter(controller);
        }
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.PROCESS;
    }

    @Override
    public Image getIcon() {
        return IconFactory.createProcessImageIcon(true);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public String getTitle() {
        return this.getPanelId();
    }

    @Override
    public void setToolBar(ToolBar toolbar) {
        this.toolbar = toolbar;
    }

    public void reload() {
        if (this.reloadOnFocus()) {
            CollaborationUniverse unviverse = (CollaborationUniverse)this.getProjectObject();
            this.setProjectObject(CollaborationUniverseImpl.create((Process)unviverse.getMainEntity().getBaseEntity()));
            this.container.remove((UiComponent)this.domain.getCanvas());
            this.buildMainPanel((UiContainer)this.container);
            this.scaleTool.setDomain(this.domain);
        }
    }

    @Override
    protected void buildUI(UiContainer parent) {
        ScrollPane scrollPane = new ScrollPane(parent, ScrollPolicy.ALWAYS);
        DesignerMode.setVisibility((UiComponent)parent, 65535);
        parent.setLayout((Layout)new BorderLayout());
        parent.add((UiComponent)scrollPane, (Object)"Center");
        this.container = new Panel((UiContainer)scrollPane);
        scrollPane.setView((UiComponent)this.container);
        this.container.setLayout((Layout)new BorderLayout());
        this.buildMainPanel((UiContainer)this.container);
        this.setReadOnly(((CollaborationUniverse)this.getProjectObject()).isReadOnly());
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new BorderLayout());
        this.scaleTool = new ScaleTool(this.domain, (UiContainer)panel);
        JScrollBar h = ((JScrollPane)scrollPane.asSwing()).getHorizontalScrollBar();
        panel.asSwing().add((Component)h, "Center");
        panel.add(this.scaleTool.getComponent(h.getHeight()), (Object)"East");
        parent.add((UiComponent)panel, (Object)"South");
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }

    @Override
    protected UiContainer createMainPanel() {
        return this;
    }

    private boolean reloadOnFocus() {
        return true;
    }

    private void buildMainPanel(UiContainer parent) {
        this.domain = new CollaborationDomain(parent, (CollaborationUniverse)this.getProjectObject());
        CollaborationCanvas canvas = this.domain.getCanvas();
        parent.add((UiComponent)canvas, (Object)"Center");
    }

    private void scrollToCenter(@NotNull FlowElementController controller) {
        Rectangle bounds = controller.getDrawableObject().getBounds();
    }

    private FlowElementController getControllerFor(@NotNull FlowElement element) {
        return null;
    }
}

