/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration;

import oracle.bpm.designer.collaboration.CollaborationDomain;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerFactory;
import oracle.bpm.diagram.editor.ControllerImpl;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;

public class CollaborationCanvas
extends PaintCanvas {
    private final CollaborationDomain domain;
    private final ControllerImpl.RootController root;
    private Dimension size;

    public CollaborationCanvas(UiContainer parent, CollaborationDomain domain) {
        super(parent);
        this.setLayout(null);
        this.domain = domain;
        this.root = this.initializeRoot();
    }

    public void paintCanvas(Graphics graphics) {
        graphics.setAntialiasing(AntialiasingMode.ON);
        DiagramContext context = this.getContext();
        context.setGraphics(graphics);
        this.root.getDrawableObject().draw();
    }

    public Dimension getPreferredSize() {
        if (this.size == null) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    public void revalidate() {
        this.size = null;
        super.revalidate();
    }

    public void resetSize() {
        this.size = null;
    }

    Controller getUniverseController() {
        return this.root.getHolder().getControllerFor((Object)this.domain.getDomainElement());
    }

    private ControllerImpl.RootController initializeRoot() {
        DrawableImpl.DrawableRoot drawable = new DrawableImpl.DrawableRoot((PaintCanvas)this, this.domain.getContext());
        ControllerImpl.RootController controller = new ControllerImpl.RootController(this.domain, drawable){

            public void refresh() {
                DrawableFactory drawableFactory = CollaborationCanvas.this.domain.getDrawableFactory();
                ControllerFactory controllerFactory = CollaborationCanvas.this.domain.getControllerFactory();
                Drawable drawable = drawableFactory.create(this.getDrawableObject(), (Object)CollaborationCanvas.this.domain.getDomainElement());
                Controller controller = controllerFactory.create((Controller)this, drawable);
                controller.refresh();
                controller.add();
            }
        };
        controller.refresh();
        return controller;
    }

    private Dimension calculateSize() {
        Dimension size = this.root.getDrawableObject().getBounds().getSize();
        return this.getContext().scale(size);
    }

    private DiagramContext getContext() {
        return this.domain.getContext();
    }
}

