/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.Watch;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.SourceCode;
import oracle.bpm.ui.ExtToolTipManager;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.PopupListener;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.table.editors.TextFieldCellEditor;

public class WatchList
extends Table
implements ListSelectionListener,
FocusListener,
CodeDebugger.WatchHandler,
MouseListener {
    private CodeDebugger debugger;
    private PopupMenu popup;

    public WatchList(UiContainer parent) {
        super(parent, ListSelectionMode.SINGLE_SELECTION);
        this.setModel((TableModel)new WatchModel());
        this.getColumn(0).setLabelProvider((LabelProvider)new ExpressionLabelProvider());
        TableColumn valueColumn = this.getColumn(1);
        valueColumn.setLabelProvider((LabelProvider)new ValueLabelProvider());
        valueColumn.setCellEditor((TableCellEditor)new ValueEditor());
        this.buildPopup();
        this.initDnd();
        ExtToolTipManager.sharedInstance().registerComponent((UiComponent)this);
    }

    public void setDebugger(CodeDebugger debugger) {
        debugger.setWatchHandler((CodeDebugger.WatchHandler)this);
        this.debugger = debugger;
    }

    public Dimension getMinimumSize() {
        return Dimension.ZERO;
    }

    public void addWatch(Watch wp) {
        this.getWachModel().addWatch(wp);
    }

    public void clear() {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.mousePressed(e);
    }

    public void mouseDoubleClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int row = this.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            this.setSelectionInterval(row, row);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mousePressed(e);
    }

    public void updateWatch(Watch wp) throws ExecutionException {
        this.getWachModel().updateWatch(wp);
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    private void initDnd() {
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        new DropTargetHandler((UiComponent)this, DndAction.MOVE, transfers){

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (transfer == TextTransfer.getInstance()) {
                    String expr = (String)data;
                    if (expr.indexOf(",") != -1) {
                        StringTokenizer tokenizer = new StringTokenizer(expr, ",");
                        while (tokenizer.hasMoreTokens()) {
                            WatchList.this.addWatch(tokenizer.nextToken());
                        }
                    } else {
                        WatchList.this.addWatch(expr);
                    }
                }
            }
        };
    }

    private WatchModel getWachModel() {
        return (WatchModel)this.getModel();
    }

    private void add() {
        String expression = MessageDialog.showInput((UiWindow)this.getOwnerWindow(), (Msg)DesignerMsg.WATCH, (Msg)DesignerMsg.WATCH_EXPRESSION);
        if (expression != null && !expression.equals("")) {
            this.addWatch(expression);
        }
    }

    private void addWatch(String expr) {
        if (this.getWachModel().containsWatch(expr)) {
            return;
        }
        try {
            Watch wp = new Watch(expr);
            this.debugger.addWatch(wp);
            this.addWatch(wp);
        }
        catch (CompilerParserException e) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_EXPRESSION, (Msg)DesignerMsg.INVALID_EXP(e.getMessage()));
        }
        catch (InvalidLanguageException e) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_EXPRESSION, (Msg)DesignerMsg.INVALID_EXP(e.getMessage()));
        }
    }

    private void buildPopup() {
        PopupMenu popup = new PopupMenu();
        popup.add((BaseAction)new AddWatchAction());
        this.addMouseListener((MouseListener)new PopupListener(popup));
        this.popup = new PopupMenu();
        this.popup.add((BaseAction)new AddWatchAction());
        this.popup.add((BaseAction)new RemoveWatchAction());
        this.addMouseListener(this);
    }

    private void remove() {
        int[] rows = this.getSelectedRows();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getWachModel().removeWatch(rows[i]);
        }
    }

    private class WatchModel
    extends AbstractTableModel {
        private ArrayList<Watch> watches_d = new ArrayList();

        WatchModel() {
        }

        public String getColumnName(int column) {
            return column == 0 ? DesignerMsg.EXPRESSION.getString() : DesignerMsg.VALUE.getString();
        }

        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            Watch watch = this.watches_d.get(row);
            return watch.getValue() instanceof ValueReference;
        }

        public Class getColumnClass(int column) {
            return Object.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.watches_d != null ? this.watches_d.size() : 0;
        }

        public void setValueAt(Object value, int row, int column) {
            Watch watch = this.watches_d.get(row);
            Object watchValue = watch.getValue();
            if (!(watchValue instanceof ValueReference)) {
                return;
            }
            ValueReference ref = (ValueReference)watchValue;
            try {
                FuegoCompiler compiler = new FuegoCompiler();
                value = compiler.evaluate(SourceCode.create(String.valueOf(value), "Fuego"), ref.getType());
                ref.set(value);
                this.fireTableDataChanged();
            }
            catch (CompilerException e) {
                MessageDialog.showError((Msg)UIMsg.TO_MSG((String)("Invalid Expression [" + ((Object)((Object)e)).getClass().getName() + "]")), (Throwable)e);
            }
        }

        public Object getValueAt(int row, int column) {
            return this.watches_d.get(row);
        }

        Watch getWatchAt(int row) {
            return this.watches_d.get(row);
        }

        void addWatch(Watch wp) {
            this.watches_d.add(wp);
            this.fireTableRowsInserted(this.watches_d.size() - 1, this.watches_d.size() - 1);
        }

        boolean containsWatch(String expr) {
            for (Watch watch : this.watches_d) {
                if (!watch.getText().equals(expr)) continue;
                return true;
            }
            return false;
        }

        void removeWatch(int row) {
            Watch wp = this.watches_d.remove(row);
            this.fireTableRowsDeleted(row, row);
            WatchList.this.debugger.removeWatch(wp);
        }

        void updateWatch(Watch wp) {
            int index = this.watches_d.indexOf(wp);
            if (index != -1) {
                this.fireTableCellUpdated(index, 1);
            }
        }
    }

    private class RemoveWatchAction
    extends BaseAction {
        RemoveWatchAction() {
            super("Remove expression");
        }

        public void run() {
            WatchList.this.remove();
        }
    }

    private class AddWatchAction
    extends BaseAction {
        AddWatchAction() {
            super("Add expression");
        }

        public void run() {
            WatchList.this.add();
        }
    }

    private static class ValueLabelProvider
    extends LabelProvider.Default<Watch> {
        Image editableIcon = Image.create((Msg)EditorMsg.VAR_EDITABLE);

        ValueLabelProvider() {
        }

        public Image getIcon(Watch watch) {
            Image icon = null;
            if (watch.getValue() instanceof ValueReference) {
                icon = this.editableIcon;
            }
            return icon;
        }

        public String getText(Watch watch) {
            String text = watch.getDumpedValue();
            String string = text = text.equals("null") ? "" : text;
            if ("EXPRESSION_NOT_IN_SCOPE".equals(watch.getValue())) {
                text = "";
            }
            return text;
        }
    }

    private static class ValueEditor
    extends TextFieldCellEditor {
        private ValueEditor() {
        }

        public Object getEditableValue(Object value) {
            Watch watch = (Watch)value;
            String text = watch.getDumpedValue();
            return text.equals("null") ? "" : text;
        }
    }

    private static class ExpressionLabelProvider
    extends LabelProvider.Default<Watch> {
        private ExpressionLabelProvider() {
        }

        public String getText(Watch watch) {
            return watch.getText();
        }
    }
}

