/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.util.Map;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.cileditor.TypeChooserPropertyEditor;
import oracle.bpm.designer.cileditor.TypeProperty;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;

public abstract class SuperTypeProperty
extends TypeProperty {
    private static final int IMPLEMENTS_SHOW_TYPE_FILTER = 1836633;
    private static final int IMPLEMENTS_SELECTION_TYPE_FILTER = 1836545;
    private static final int SHOW_TYPE_FILTER = 1050201;
    private static final int[] SHOW_TYPE_EXCLUDE_FILTER = new int[]{1, 524288};
    private static final int SELECTION_TYPE_FILTER = 0x100601;
    private static final int SELECTION_TYPE_EXCLUDE_FILTER = 524288;

    private SuperTypeProperty(Msg key, SuperType superType, TypeDescription typeToAvoid) {
        super(key, superType, typeToAvoid);
    }

    public static boolean isImplementable(TypeRef typeRef) {
        String componentType = typeRef.getComponentType();
        TypeRef parent = typeRef.get().getParentRef();
        boolean isImplementableFo = SuperTypeProperty.isFObject(componentType) && !SuperTypeProperty.isFObject(parent.getComponentType());
        boolean isImplementableWebService = SuperTypeProperty.isWebservice(componentType) && Modifier.isAbstract(typeRef.getModifiers()) && SuperTypeProperty.isWebservice(parent.getComponentType());
        boolean isImplementableJava = SuperTypeProperty.isJava(componentType);
        TypeDescription typeDescription = typeRef.get();
        boolean isRemote = typeDescription.isObject() && typeDescription.asObject().isRemote();
        boolean isPresentableInterface = "Fuego.Lang.Presentable".equals(typeRef.getText());
        boolean isPackageOrModule = SuperTypeProperty.isPackageOrModule(typeRef);
        return (isImplementableFo || isImplementableWebService || isImplementableJava) && !isPresentableInterface && !isPackageOrModule && !isRemote;
    }

    public static SuperTypeProperty createDelegateProperty(SuperType superType, final ObjectTypeDescription objectTypeDescription) {
        return new SuperTypeProperty(DesignerMsg.DELEGATE_PROPERTY, superType, (TypeDescription)objectTypeDescription){

            @Override
            public TypeChooserPropertyEditor getEditor(ComponentCatalog catalog) {
                return new SuperTypeEditor(this, objectTypeDescription.getCatalog());
            }
        };
    }

    public static SuperTypeProperty createImplementProperty(SuperType superType, final ObjectTypeDescription objectTypeDescription) {
        return new SuperTypeProperty(DesignerMsg.INHERIT_PROPERTY, superType, (TypeDescription)objectTypeDescription){

            @Override
            public TypeChooserPropertyEditor getEditor(ComponentCatalog catalog) {
                return new ImplementEditor(this, objectTypeDescription.getCatalog());
            }
        };
    }

    private static boolean isWebservice(String componentType) {
        return "web service".equals(componentType);
    }

    private static boolean isJava(String componentType) {
        return ComponentType.JAVA.getText().equals(componentType);
    }

    private static boolean isFObject(String componentType) {
        return ComponentType.XOBJECT.getText().equals(componentType);
    }

    private static boolean isPackageOrModule(TypeRef typeRef) {
        boolean result = false;
        if ("java".equals(typeRef.getComponentType()) && typeRef instanceof ObjectTypeDescription) {
            String isPackage;
            ObjectTypeDescription objectTypeDescription = (ObjectTypeDescription)typeRef;
            Map<String, String> properties = objectTypeDescription.getProperties();
            if (properties != null && !properties.isEmpty() && (isPackage = properties.get("isPackage")) != null) {
                result = Boolean.valueOf(isPackage);
            }
        } else if ("object".equals(typeRef.getComponentType())) {
            result = typeRef.get().isModule();
        }
        return result;
    }

    private static abstract class AbstractSuperTypeEditor
    extends TypeChooserPropertyEditor {
        public String prevValue;
        protected TypesFilter selectionFilter;
        protected TypesFilter typesFilter;
        private SuperTypeProperty typeProperty;

        public AbstractSuperTypeEditor(SuperTypeProperty typeProperty, ComponentCatalog catalog) {
            super(typeProperty, catalog);
            this.typeProperty = typeProperty;
        }

        public boolean stopCellEditing() {
            this.typeProperty.setEditorValue(this.getCellEditorValue());
            return super.stopCellEditing();
        }

        protected abstract TypesFilter createSelectionFilter();

        protected abstract TypesFilter createTypesFilter();

        @Override
        protected int getOptions() {
            return 9;
        }

        @Override
        protected TypesFilter getSelectionFilter() {
            if (this.selectionFilter == null) {
                this.selectionFilter = this.createSelectionFilter();
            }
            return this.selectionFilter;
        }

        @Override
        protected TypesFilter getTypesFilter() {
            if (this.typesFilter == null) {
                this.typesFilter = this.createTypesFilter();
            }
            return this.typesFilter;
        }
    }

    public static class SuperTypeEditor
    extends AbstractSuperTypeEditor {
        public SuperTypeEditor(SuperTypeProperty typeProperty, ComponentCatalog catalog) {
            super(typeProperty, catalog);
        }

        @Override
        protected TypesFilter createSelectionFilter() {
            return new TypesFilter(0x100601, 524288){
                private boolean canSee;
                private boolean hasDefaultInit;

                @Override
                public boolean isValid(TypeRef type, ComponentCatalog catalog) {
                    this.canSee = SuperTypeEditor.this.canSee(type);
                    return this.canSee && this.hasDefaultInit(type) && super.isValid(type, catalog);
                }

                private boolean hasDefaultInit(TypeRef type) {
                    this.hasDefaultInit = type.get().hasDefaultInit();
                    return this.hasDefaultInit;
                }

                @Override
                public Msg getInvalidSelectionMsg(String componentName) {
                    Msg result = super.getInvalidSelectionMsg(componentName);
                    if (this.canSee && !this.hasDefaultInit) {
                        result = DesignerMsg.TYPE_FILTER_MUST_HAVE_DEFAULT_INIT(componentName);
                    }
                    return result;
                }
            };
        }

        @Override
        protected TypesFilter createTypesFilter() {
            return new TypesFilter(1050201, SHOW_TYPE_EXCLUDE_FILTER){

                @Override
                public boolean isValid(TypeRef type, ComponentCatalog catalog) {
                    return SuperTypeEditor.this.canSee(type) && super.isValid(type, catalog);
                }
            };
        }

        private boolean canSee(TypeRef type) {
            return type != null && !type.get().isEnum();
        }
    }

    public static class ImplementEditor
    extends AbstractSuperTypeEditor {
        public ImplementEditor(SuperTypeProperty typeProperty, ComponentCatalog catalog) {
            super(typeProperty, catalog);
        }

        @Override
        protected TypesFilter createSelectionFilter() {
            return new TypesFilter(1836545){
                private boolean isImplementable;
                private boolean typeIsNull;

                @Override
                public boolean isValid(TypeRef type, ComponentCatalog catalog) {
                    return this.canImplement(type) && super.isValid(type, catalog);
                }

                private boolean canImplement(TypeRef type) {
                    boolean bl = this.typeIsNull = type == null;
                    if (!this.typeIsNull) {
                        this.isImplementable = SuperTypeProperty.isImplementable(type);
                    }
                    return !this.typeIsNull && this.isImplementable;
                }

                @Override
                public Msg getInvalidSelectionMsg(String componentName) {
                    Msg result = super.getInvalidSelectionMsg(componentName);
                    if (!this.typeIsNull && !this.isImplementable) {
                        result = DesignerMsg.TYPE_FILTER_COMPONENT_NOT_IMPLEMENTABLE(componentName);
                    }
                    return result;
                }
            };
        }

        @Override
        protected TypesFilter createTypesFilter() {
            return new TypesFilter(1836633){

                @Override
                public boolean isValid(TypeRef type, ComponentCatalog catalog) {
                    return type != null && (SuperTypeProperty.isImplementable(type) || catalog.hasChildren(type)) && super.isValid(type, catalog);
                }
            };
        }
    }
}

