/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import oracle.bpm.project.model.processes.StorageType;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.AbstractEditor;

public class StorageTypeProperty
extends AbstractProperty {
    private static StorageTypeRenderer renderer = null;
    private static StorageTypeEditor editor = null;

    public StorageTypeProperty(StorageType storageType) {
        this.setKey(UIMsg.CATEGORY);
        this.setValue(storageType);
        if (renderer == null) {
            renderer = new StorageTypeRenderer();
        }
        if (editor == null) {
            editor = new StorageTypeEditor();
        }
        this.setPropertyRenderer(renderer);
        this.setPropertyEditor((PropertyEditor)editor);
    }

    private static class StorageTypeRenderer
    implements PropertyRenderer {
        private StorageTypeRenderer() {
        }

        public String getRenderer(Property property) {
            return StorageTypeRenderer.renderProperty(property);
        }

        public String getToolTip(Property property) {
            return StorageTypeRenderer.renderProperty(property);
        }

        private static String renderProperty(Property property) {
            StorageType storageType = (StorageType)property.getValue();
            return storageType.getString();
        }
    }

    private static class StorageTypeEditor
    extends AbstractEditor {
        private ComboBox editor;

        private StorageTypeEditor() {
        }

        public Object getCellEditorValue() {
            return this.editor.getSelectedItem();
        }

        public UiComponent getEditor(UiContainer parent) {
            this.editor = this.createEditor(parent);
            return this.editor;
        }

        private ComboBox createEditor(UiContainer parent) {
            ComboBox editor = UiFactory.createComboBox((UiContainer)parent, (Object[])new StorageType[]{StorageType.NORMAL, StorageType.SEPARATED});
            StorageType storageType = (StorageType)this.getProperty().getValue();
            editor.setSelectedItem((Object)storageType);
            return editor;
        }
    }
}

