/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bpm.designer.cileditor.LocalVariablePropertyRenderer;
import oracle.bpm.designer.cileditor.TypeProperty;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.Variable;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.EditorFactory;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.Status;
import oracle.bpm.util.Identifier;

public class LocalVariableProperty
extends PropertyGroup {
    private AbstractProperty desc;
    private MethodTypeDescription method;
    private AbstractProperty name;
    private AbstractProperty type;
    static LocalVariablePropertyRenderer renderer = new LocalVariablePropertyRenderer();

    public LocalVariableProperty(String key, Variable variable, MethodTypeDescription method) {
        this(key, variable, method, false);
    }

    public LocalVariableProperty(String key, Variable variable, MethodTypeDescription method, boolean isNew) {
        this(key, variable, method, isNew, null);
    }

    public LocalVariableProperty(String key, Variable variable, MethodTypeDescription method, boolean isNew, ComponentCatalog catalog) {
        super(key);
        this.setValue(variable);
        this.name = Factory.createIdentifierText((Msg)ProjectDrawMsg.NAME, (String)variable.getName());
        this.type = new TypeProperty(CoreMsg.TYPE, variable, isNew, catalog);
        this.desc = Factory.createLongText((Msg)DesignerMsg.DESCRIPTION, (String)variable.getDescription());
        this.method = method;
        this.add((Property)this.name);
        this.add((Property)this.type);
        this.add((Property)this.desc);
        this.setPropertyRenderer(renderer);
        this.setPropertyEditor(EditorFactory.TEXT_EDITOR);
        this.name.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.type.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.desc.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public Object getDefaultEditable() {
        return this.name;
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        if (this.name != null) {
            this.name.setEditable(b);
        }
        if (this.type != null) {
            this.type.setEditable(b);
        }
        if (this.desc != null) {
            this.desc.setEditable(b);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Variable variable;
        if (evt.getSource() == this.name) {
            Variable member;
            variable = (Variable)this.getValue();
            String newVariableName = evt.getNewValue().toString();
            if (newVariableName.length() == 0) {
                this.firePropertyCheck(this, (Property)evt.getSource());
                return;
            }
            if (Character.isUpperCase(newVariableName.charAt(0)) || !Identifier.isValid(newVariableName)) {
                this.name.setStatus(Status.ERROR_STATUS((Msg)DesignerMsg.INVALID_IDENTIFIER));
                this.firePropertyCheck(this, (Property)evt.getSource());
                return;
            }
            String prevValue = variable.getName();
            String oldVariableName = evt.getOldValue() != null ? evt.getOldValue().toString() : "";
            boolean arg = false;
            if (this.getValue() instanceof Argument) {
                arg = true;
                member = variable.getParent() != null ? variable.getParent().findArgument(newVariableName) : null;
            } else {
                MethodTypeDescription methodTypeDescription = this.getMethod();
                Variable variable2 = member = methodTypeDescription != null ? methodTypeDescription.findVariable(newVariableName) : null;
            }
            if (member != null && !variable.getName().equals(newVariableName)) {
                this.name.setStatus(Status.ERROR_STATUS((Msg)(arg ? DesignerMsg.ARGUMENT_ALREADY_DEFINED(newVariableName) : DesignerMsg.VARIABLE_ALREADY_DEFINED(newVariableName))));
                this.name.setValue((Object)oldVariableName);
                this.firePropertyCheck(this, (Property)evt.getSource());
                return;
            }
            variable.setName(newVariableName);
            this.setKey(newVariableName);
            evt = new PropertyChangeEvent((Object)this, this.name.getKey(), prevValue, this.getValue());
        } else if (evt.getSource() == this.desc) {
            variable = (Variable)this.getValue();
            variable.setDescription(evt.getNewValue().toString());
        }
        MethodTypeDescription method = this.getMethod();
        super.propertyChange(evt);
    }

    public MethodTypeDescription getMethod() {
        return this.method;
    }
}

