/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.util.List;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.LineBreakPoint;
import oracle.bpm.designer.action.DelegateAction;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;

public class ExecutionAction
extends DelegateAction {
    private CodeEditor codeEditor;
    private CodeDebugger debugger;
    private boolean initialized;

    public ExecutionAction(CodeEditor editorPane, CodeDebugger debugger, BaseAction innerAction) {
        super(innerAction.getMsg());
        this.setDelegateAction(innerAction);
        this.setCodeEditor(editorPane);
        this.debugger = debugger;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        BaseAction delegateAction = this.getDelegateAction();
        if (delegateAction != null) {
            delegateAction.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isInitialized()) {
            this.initDebugger();
        }
        super.actionPerformed(e);
        this.setInitialized(false);
    }

    protected void setCodeEditor(CodeEditor editorPanel) {
        this.codeEditor = editorPanel;
    }

    protected CodeEditor getCodeEditor() {
        return this.codeEditor;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void addBreakPointsTo(CodeEditor editor, CodeDebugger codeDebugger) {
        List lineBreakPoints = editor.getLineBreakPoints();
        codeDebugger.removeAllBreakPoints();
        for (LineBreakPoint bp : lineBreakPoints) {
            try {
                codeDebugger.addBreakPoint((BreakPoint)bp);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected void initDebugger() {
        CodeDebugger codeDebugger = this.debugger;
        this.addBreakPointsTo(this.getCodeEditor(), codeDebugger);
        this.setInitialized(true);
    }
}

