/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class DebuggerPropertiesPanel
extends Panel {
    private ComboBox<String> activitiesCombo;
    private ComboBox<String> participantCombo;

    public DebuggerPropertiesPanel(UiContainer parent, Process model) {
        super(parent);
        String colSpecs = "5dlu, pref, 5dlu, pref, 5dlu";
        String rowSpecs = "5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        this.participantCombo = UiFactory.createComboBox((UiContainer)this);
        Sequence participants = model.getProject().getOrganization().getParticipants();
        for (Participant participant : participants) {
            this.participantCombo.addItem((Object)participant.getId());
        }
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PARTICIPANT), cc.xy(2, 2));
        builder.add(this.participantCombo, cc.xy(4, 2));
        this.activitiesCombo = UiFactory.createComboBox((UiContainer)this);
        Sequence nodes = model.getFlowNodes();
        for (FlowNode node : nodes) {
            this.activitiesCombo.addItem((Object)node.getId());
        }
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ACTIVITY_ID), cc.xy(2, 4));
        builder.add(this.activitiesCombo, cc.xy(4, 4));
    }

    public String getActivity() {
        return (String)this.activitiesCombo.getSelectedItem();
    }

    public String getParticipant() {
        return (String)this.participantCombo.getSelectedItem();
    }
}

