/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalogdoc;

import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.ui.CloseableDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.util.documentation.DocumentationUtils;

class PreviewDialog
extends CloseableDialog {
    private TextArea viewer;

    public PreviewDialog(UiWindow owner, JTextPane textPane) {
        super(owner, DesignerMsg.HTML_VIEWER, false);
        this.init(textPane);
    }

    public void ok() {
        this.close();
    }

    private void init(final JTextPane textPane) {
        UiContainer container = this.getContentPane();
        String htmlString = DocumentationUtils.getDocumentation(textPane);
        this.viewer = new TextArea(container);
        this.viewer.setText(htmlString);
        this.viewer.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClicked(MouseEvent e) {
                PreviewDialog.this.updateViewer(textPane);
            }
        });
        this.viewer.setToolTipText("Press Double-Click to refresh");
        textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PreviewDialog.this.updateViewer(textPane);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PreviewDialog.this.updateViewer(textPane);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PreviewDialog.this.updateViewer(textPane);
            }
        });
        container.add((UiComponent)this.viewer, (Object)"Center");
        this.setSize(600, 700);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void updateViewer(JTextPane textPane) {
        String oldHtml;
        String newHtml = DocumentationUtils.getDocumentation(textPane);
        if (!newHtml.equals(oldHtml = this.viewer.getText())) {
            this.viewer.setText(newHtml);
        }
    }
}

