/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalogdoc;

import oracle.bpm.designer.catalogdoc.HRefComponent;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

class HRefDialog
extends OkCancelDialog {
    private HRefComponent hrefComponent;

    private HRefDialog(UiWindow parent, Msg msg, HRefComponent.Value defaultValue) {
        super(parent, msg, true);
        this.init(defaultValue);
        this.pack();
        this.setLocationRelativeTo((UiComponent)parent);
    }

    public static HRefDialog createHyperlink(UiWindow parent, HRefComponent.Value defaultValue) {
        return new HRefDialog(parent, DesignerMsg.CREATE_HYPERLINK, defaultValue);
    }

    public static HRefDialog editHyperlink(UiWindow parent, HRefComponent.Value defaultValue) {
        return new HRefDialog(parent, DesignerMsg.EDIT_HYPERLINK, defaultValue);
    }

    public HRefComponent.Value getHRef() {
        assert (this.hrefComponent != null);
        return this.hrefComponent.getHRef();
    }

    public void ok() {
        try {
            this.hrefComponent.validateForm();
            this.setUserAccepted(true);
            this.close();
        }
        catch (InputValidationException e) {
            MessageDialog.showError((Msg)e.getKey());
        }
    }

    private void init(HRefComponent.Value defaultValue) {
        UiContainer container = this.getContentPane();
        this.hrefComponent = new HRefComponent(container, defaultValue);
        container.add((UiComponent)this.hrefComponent, (Object)"Center");
    }
}

