/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.SeparatorTreeNode;
import oracle.bpm.designer.action.SelectObjectMemberAction;
import oracle.bpm.designer.catalog.tree.CatalogObjectNode;
import oracle.bpm.designer.catalog.tree.ObjectAttributeMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectMethodMemberTreeNode;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.utils.FontUtils;

@TreeNodeMetadata(objectType=CatalogMember.class)
public class ObjectMemberTreeNode
extends ProjectObjectTreeNode<CatalogMember>
implements DragItem {
    public ObjectMemberTreeNode(CatalogMember member) {
        super((ProjectObject)member);
    }

    public static ObjectMemberTreeNode create(CatalogMember member) {
        ObjectMemberTreeNode result = null;
        if (member.isMethod()) {
            result = new ObjectMethodMemberTreeNode(member);
        } else if (member.isAttribute()) {
            result = new ObjectAttributeMemberTreeNode(member);
        }
        return result;
    }

    @Override
    public Image getIcon() {
        return IconFactory.getIconFor(this.getMember());
    }

    public boolean isLeaf() {
        return true;
    }

    public MethodTypeDescription getMember() {
        Object object = this.getUserObject();
        if (object instanceof CatalogMember) {
            return ((CatalogMember)object).getMemberType();
        }
        MethodTypeDescription.MethodRef ref = (MethodTypeDescription.MethodRef)object;
        return ref.get();
    }

    public long getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    public String getName() {
        return this.getMember().getName();
    }

    public String getTemplate() {
        StringBuffer text = new StringBuffer();
        text.append(FuegoCILSourceGenerator.generateTemplate((MethodTypeDescription)this.getMember(), (String)this.getMember().getParent().getName()));
        return text.toString();
    }

    public int getUnderLineModifiers() {
        if (Modifier.isDeprecated(this.getModifiers()) || Modifier.isDeprecated(this.getMember().getModifiers())) {
            return FontUtils.UNDERLINE_STRIKETHROUGH;
        }
        return super.getUnderLineModifiers();
    }

    @Override
    public ObjectMemberTreeNode asObjectMemberTreeNode() {
        return this;
    }

    @Override
    public void doubleClick(MouseEvent e) {
        new SelectObjectMemberAction(this.getMember()).doIt();
    }

    public void refreshMemberVisibility(int mask) {
        boolean isDelegated;
        boolean isInherited = Modifier.isInherited(this.getModifiers()) && !Modifier.isInherited(mask);
        boolean bl = isDelegated = Modifier.isDelegated(this.getModifiers()) && !Modifier.isInherited(mask);
        if (isInherited || isDelegated) {
            this.removeFromParent();
        }
    }

    @Override
    public String toString() {
        TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
        return renderer.render((TypeRef)this.getMember(), this.getMember().getParent(), 32);
    }

    public Transfer[] getTransfers() {
        Transfer[] transferArray;
        boolean isValid;
        MethodTypeDescription member = this.getMember();
        boolean bl = isValid = member.isMethod() || member.isAttribute() || member.isTransformation();
        if (isValid) {
            Transfer[] transferArray2 = new Transfer[2];
            transferArray2[0] = LocalObjectTransfer.getInstance(MethodTypeDescription.class);
            transferArray = transferArray2;
            transferArray2[1] = TextTransfer.getInstance();
        } else {
            transferArray = Transfer.NONE;
        }
        return transferArray;
    }

    public Object getObjectAs(Transfer transfer) {
        Object result = LocalObjectTransfer.getInstance(MethodTypeDescription.class) == transfer ? this.getMember() : (TextTransfer.getInstance() == transfer ? this.getMember().getName() : null);
        return result;
    }

    protected boolean isEditable() {
        CatalogObjectNode parent;
        CatalogObject parentModel;
        boolean isReadonly;
        TreeNode treeNode = this.getParent();
        if (treeNode instanceof SeparatorTreeNode) {
            treeNode = treeNode.getParent();
        }
        return !(isReadonly = (parentModel = (parent = (CatalogObjectNode)treeNode).getObjectModel()).isReadOnly());
    }

    private Project getProject(TypeRef ref) {
        return FuegoProject.getFrom((TypeRef)ref);
    }
}

