/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.designer.UiTypeObserverDecorator;
import oracle.bpm.designer.action.ComponentActions;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.action.OpenCatalogNodeAction;
import oracle.bpm.designer.catalog.tree.CatalogNodeLoader;
import oracle.bpm.designer.catalog.tree.CatalogObjectComponentTreeNode;
import oracle.bpm.designer.catalog.tree.CatalogObjectNode;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeObserver;
import oracle.bpm.type.TypeObserverImpl;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;

public class CatalogObjectStructureTreeNode
extends CatalogObjectComponentTreeNode
implements CatalogObjectNode {
    private CatalogNodeLoader catalogNodeLoader;
    private Exception creation;
    private Image icon;
    private long modifiers = 0L;
    private Project project;
    private TypeObserver typeObserver;

    public CatalogObjectStructureTreeNode(CatalogObject object) {
        this(object, 0L);
    }

    public CatalogObjectStructureTreeNode(CatalogObject object, long mods) {
        this.project = object.getProject();
        this.setUserObject(object);
        this.modifiers = mods;
        this.addTypeObserver();
        this.creation = new Exception("created:" + object.getObjectType());
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public String getComponentType() {
        return this.getTypeInfo().getType();
    }

    @Override
    public Image getIcon() {
        if (this.icon == null) {
            this.icon = IconFactory.getIconFor(this.getTypeRef());
        }
        return this.icon;
    }

    public boolean isIntrospectionRoot() {
        return !this.isModule() && this.isWithinAModule();
    }

    public boolean isWithinAModule() {
        return this.getParent() != null && ((CatalogObjectStructureTreeNode)this.getParent()).isModule();
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public TypeRef getTypeRef() {
        return this.getUserObject().getObjectType();
    }

    @Override
    public ObjectTypeDescription getObject() {
        return this.getTypeRef().get().asObject();
    }

    @Override
    public ActionGroup createActions() {
        return new ComponentActions(this.getProject(), this.getUserObject()).getActions();
    }

    @Override
    public TreeNode createInner(CatalogObject innerTypeModel, long modifiers) {
        return new CatalogObjectStructureTreeNode(innerTypeModel, modifiers);
    }

    public boolean delete() {
        this.removeListeners();
        return this.createDeleteAction().doIt();
    }

    @Override
    public DesignerAction getOpenAction() {
        if (this.isModule()) {
            return null;
        }
        return new OpenCatalogNodeAction();
    }

    public CatalogObject getUserObject() {
        return (CatalogObject)super.getUserObject();
    }

    @Override
    public CatalogObject getObjectModel() {
        return this.getUserObject();
    }

    public void reload() {
        this.icon = null;
        this.setUpdatingBatch(true);
        this.loadMembers();
        this.setUpdatingBatch(false);
        super.reload();
    }

    @Override
    public void removeFromRepository() throws TypeCatalogException {
        this.getCatalog().remove(this.getTypeRefText());
    }

    public String toString() {
        return TypeUtils.shortName(this.getTypeRefText());
    }

    @Override
    public TreeNode asTreeNode() {
        return this;
    }

    @Override
    public Exception debugInfo() {
        return this.creation;
    }

    protected void onLoading() {
        this.loadMembers();
    }

    protected void removeListeners() {
        this.getTypeRef().removeObserver(this.typeObserver);
    }

    private void addTypeObserver() {
        this.typeObserver = new UiTypeObserverDecorator(new TypeObserverImpl(){

            @Override
            public void typeChanged(TypeRef thisType) {
                CatalogObjectStructureTreeNode.this.loadMembers();
            }
        });
        this.getTypeRef().addObserver(this.typeObserver);
    }

    private DeleteObjectAction createDeleteAction() {
        return DeleteActionFactory.getDeleteActionFor((ProjectObject)this.getObjectModel());
    }

    private String getTypeRefText() {
        return this.getTypeRef().getText();
    }

    private TypeInfo getTypeInfo() {
        return ((MutableComponentCatalog)this.getUserObject().getProject().getComponentCatalog()).getInfo(this.getTypeRef());
    }

    private MutableComponentCatalog getCatalog() {
        return (MutableComponentCatalog)this.getTypeRef().getCatalog();
    }

    private void loadMembers() {
        if (this.getTree() == null || this.getTree().isDisposed() || this.getTypeInfo() == null) {
            return;
        }
        StructureTree filter = (StructureTree)this.getTree();
        boolean groupInheritedMembers = filter.isGroupInheritedMembers();
        boolean isMutable = this.isMutable();
        boolean showMethod = filter.showMethods();
        boolean showAttributes = filter.showAttributes();
        boolean showPresentations = filter.showPresentations();
        boolean showDelegated = true;
        boolean showInherited = true;
        boolean showGroups = false;
        boolean showProjectInherited = false;
        this.getCatalogNodeLoader().load(this.getUserObject(), this, groupInheritedMembers, isMutable, showMethod, showAttributes, showPresentations, showDelegated, showInherited, showGroups, this.modifiers, showProjectInherited);
    }

    private CatalogNodeLoader getCatalogNodeLoader() {
        if (this.catalogNodeLoader == null) {
            this.catalogNodeLoader = new CatalogNodeLoader(this.getProject());
        }
        return this.catalogNodeLoader;
    }
}

