/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;

public abstract class CatalogObjectComponentTreeNode
extends AbstractTreeNode {
    public abstract Image getIcon();

    public abstract void removeFromRepository() throws TypeCatalogException;

    @Override
    public BaseAction getActionForId(int actionId) {
        if (actionId == 1) {
            return this.getDeleteAction();
        }
        if (actionId == 2) {
            return this.getOpenAction();
        }
        return super.getActionForId(actionId);
    }

    public String getComponentType() {
        return ComponentType.OBJECT.getText();
    }

    public BaseAction getDeleteAction() {
        return null;
    }

    public boolean isModule() {
        return this.getComponentType().equals(ComponentType.OBJECT.getText());
    }

    public boolean isMutable() {
        return this.getComponentType().equals(ComponentType.XOBJECT.getText());
    }

    public DesignerAction getOpenAction() {
        return null;
    }

    public StructureTree getStructureTree() {
        return (StructureTree)this.getTree();
    }

    public String getTemplate() {
        return "";
    }

    public TreePath getTreePath() {
        ArrayList<TreeNode> l = new ArrayList<TreeNode>();
        this.getParentNodes(l, this);
        l.add(this);
        return TreePath.create((Object[])l.toArray());
    }

    public void doubleClick(MouseEvent e) {
        super.doubleClick(e);
        DesignerAction open = this.getOpenAction();
        if (open != null) {
            open.runWithSelection(this.getUserObject());
        }
    }

    @Override
    public void refresh(String qualifiedName) {
        if (this.isLoaded()) {
            super.refresh(qualifiedName);
        }
    }

    public void refreshMemberVisibility(int mask) {
        if (this.isLoaded()) {
            int count = this.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                CatalogObjectComponentTreeNode tree = (CatalogObjectComponentTreeNode)this.getChildAt(i);
                tree.refreshMemberVisibility(mask);
            }
        }
    }

    public void reloadParent() {
        if (this.getParent() != null) {
            this.getParent().reload();
        }
    }

    @Override
    protected int getMultipleActionsMask() {
        return 1;
    }

    private void getParentNodes(List<TreeNode> list, TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        list.add(0, parent);
        this.getParentNodes(list, parent);
    }
}

