/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.OpenCloseMemberAccessorAction;
import oracle.bpm.designer.action.RemoveAttributeAccessorAction;
import oracle.bpm.designer.catalog.tree.CatalogObjectComponentTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectAttributeMemberTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

public class AttributeMemberAccessorTreeNode
extends CatalogObjectComponentTreeNode {
    private final int accessorType;
    private final AttributeTypeDescription member;
    private ObjectPropertyListener memberListener;
    private DesignerAction remove;

    public AttributeMemberAccessorTreeNode(int accessorType, @NotNull AttributeTypeDescription member) {
        this.accessorType = accessorType;
        this.member = member;
        if (accessorType == 8) {
            this.setMsg(DesignerMsg.READ_ACCESS_CODE);
        } else if (accessorType == 7) {
            this.setMsg(DesignerMsg.WRITE_ACCESS_CODE);
        }
        this.setUserObject(member);
        this.initListeners();
    }

    public int getAccessorType() {
        return this.accessorType;
    }

    @Override
    public BaseAction getDeleteAction() {
        boolean isEditable = this.getParentNode().isEditable();
        return isEditable ? this.getRemoveAction() : null;
    }

    @Override
    public Image getIcon() {
        return Image.create((Msg)this.getMsg());
    }

    public AttributeTypeDescription getParentAttribute() {
        return this.member;
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup(DesignerMsg.ATTRIBUTE);
        CatalogObject parent = CatalogObjectImpl.create((TypeRef)this.getParentMember().getParent());
        OpenCloseMemberAccessorAction openClose = new OpenCloseMemberAccessorAction(parent, this.getParentAttribute(), this.getAccessorType());
        result.add((BaseAction)openClose);
        result.add((BaseAction)this.getRemoveAction());
        return result;
    }

    public boolean delete() {
        return this.getRemoveAction().doIt();
    }

    @Override
    public void removeFromRepository() throws TypeCatalogException {
    }

    public String toString() {
        return this.getMsg().toString();
    }

    @Override
    protected String getName() {
        return this.getMsg().getCode();
    }

    protected void removeListeners() {
        if (this.accessorType == 8) {
            this.member.removePropertyObserver("hasGetter", this.memberListener);
        } else if (this.accessorType == 7) {
            this.member.removePropertyObserver("hasSetter", this.memberListener);
        }
        super.removeListeners();
    }

    private void initListeners() {
        this.memberListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                AttributeMemberAccessorTreeNode.this.member.getParent().asObject().fireTypeChanged();
            }
        };
        if (this.accessorType == 8) {
            this.member.addPropertyObserver("hasGetter", this.memberListener);
        } else if (this.accessorType == 7) {
            this.member.addPropertyObserver("hasSetter", this.memberListener);
        }
    }

    private DesignerAction getRemoveAction() {
        if (this.remove == null) {
            this.remove = new RemoveAttributeAccessorAction(this.getParentMember(), this.getAccessorType());
        }
        return this.remove;
    }

    private ObjectAttributeMemberTreeNode getParentNode() {
        return (ObjectAttributeMemberTreeNode)this.getParent();
    }

    private AttributeTypeDescription getParentMember() {
        ObjectAttributeMemberTreeNode parentNode = this.getParentNode();
        return parentNode.getMember().asAttribute();
    }
}

