/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.panel;

import java.text.DateFormat;
import java.util.Locale;
import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentEditorProvider;
import oracle.bpm.designer.catalog.panel.CatalogObjectProperty;
import oracle.bpm.designer.catalog.panel.CatalogObjectTable;
import oracle.bpm.designer.catalog.panel.CatalogObjectTableModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.draw.Color;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.TableLabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.table.editors.TextFieldCellEditor;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.xobject.runtime.ConversionUtilities;

class CatalogObjectTableDecorators {
    CatalogObjectTableDecorators() {
    }

    static class TypeRefLabelProvider
    extends LabelProvider.Default<TypeRef> {
        TypeRefLabelProvider() {
        }

        public String getText(TypeRef typeRef) {
            TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
            return renderer.render((TypeRef)typeRef.get().primitiveEquivalent(true));
        }
    }

    static class TypeChooserCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComponentCatalog catalog;
        private TypeChooserPanel chooserPanel;

        TypeChooserCellEditor(ComponentCatalog catalog) {
            this.catalog = catalog;
        }

        public Object getCellEditorValue() {
            return this.chooserPanel.getEnsuredSelectedItem();
        }

        public UiComponent getTableCellEditor(Table table, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)table, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.chooserPanel = TypeChooserPanel.create(parent, this.catalog, this.isMethod(), this.getOptions(), this.getTypesFilter(), this.getSelectionFilter());
            TypeRef variable = (TypeRef)value;
            if (variable != null) {
                this.chooserPanel.setInitialType(CatalogTypeImpl.get((TypeRef)variable.get()), false);
            }
            this.chooserPanel.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    TypeChooserCellEditor.this.stopCellEditing();
                }
            });
            TypeChooserPanel.EnsuredItemListener<CatalogType> itemListener = new TypeChooserPanel.EnsuredItemListener<CatalogType>(){

                @Override
                public void itemStateChanged(TypeChooserPanel.EnsuredItemEvent<CatalogType> event) {
                    if (event.isFromCombo()) {
                        TypeChooserCellEditor.this.stopCellEditing();
                    }
                }
            };
            this.chooserPanel.addTypedItemListener(itemListener);
            return this.chooserPanel;
        }

        private int getOptions() {
            return 3;
        }

        private TypesFilter getSelectionFilter() {
            return null;
        }

        private TypesFilter getTypesFilter() {
            return null;
        }

        private boolean isMethod() {
            return false;
        }
    }

    static class DefaultValueLabelProvider
    extends TableLabelProvider.Default<String> {
        private final CatalogObjectTableModel memberModel;

        DefaultValueLabelProvider(CatalogObjectTableModel memberModel) {
            this.memberModel = memberModel;
        }

        public String getText(String value) {
            if (value == null) {
                return "null";
            }
            if (Str.isEmpty(value)) {
                return value;
            }
            CatalogMember member = (CatalogMember)this.memberModel.getRow(this.getRow());
            AttributeTypeDescription attributeTypeDescription = member.getMemberType().asAttribute();
            int kind = attributeTypeDescription.getResultType().getKind();
            switch (kind) {
                case 7: {
                    try {
                        Interval interval = (Interval)ConversionUtilities.fromString((String)value, (int)7);
                        return IntervalFormat.getInstance().format(interval);
                    }
                    catch (IntervalFormatException e) {
                        return value;
                    }
                }
                case 6: {
                    try {
                        Time time = (Time)ConversionUtilities.fromString((String)value, (int)6);
                        Locale locale = Locale.getDefault();
                        int restrictions = attributeTypeDescription.getPrecision();
                        TimeField.Style style = ComponentEditorProvider.getStyle(restrictions);
                        DateFormat dateFormat = TimeField.getDateFormat((TimeField.Style)style, (TimeField.Format)TimeField.Format.CUSTOM, (Locale)locale);
                        return time.format(dateFormat);
                    }
                    catch (TimeFormatException e) {
                        return value;
                    }
                }
            }
            return value;
        }
    }

    static class DefaultValueColorProvider
    extends TableColorProvider.ReadOnly {
        private final CatalogObjectTableModel model;

        DefaultValueColorProvider(CatalogObjectTableModel model) {
            super((TableModel)model, CatalogObjectProperty.DEFAULT_VALUE.ordinal());
            this.model = model;
        }

        public Color getForeground(Object element) {
            Color result = this.model.getValueAt(this.getRow(), CatalogObjectProperty.DEFAULT_VALUE.ordinal()) == null ? Color.LIGHT_GRAY : Color.BLACK;
            return result;
        }
    }

    static class DefaultValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private UiComponent uiComponent;

        DefaultValueCellEditor() {
        }

        public Object getCellEditorValue() {
            return this.getValue(this.uiComponent);
        }

        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)parent, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            CatalogObjectTable table = (CatalogObjectTable)parent;
            int row = table.getSelectedRow();
            CatalogObjectTableModel model = table.getModel();
            AttributeTypeDescription attribute = ((CatalogMember)model.getRow(row)).getMemberType().asAttribute();
            int kind = attribute.getType().getKind();
            String textToSet = (String)value;
            this.uiComponent = ComponentEditorProvider.getEditor(parent, kind, attribute.getPrecision(), textToSet);
            return this.uiComponent;
        }

        private Object getValue(UiComponent current) {
            String result = "";
            if (current instanceof TextField) {
                TextField textField = (TextField)current;
                if (textField instanceof NumericField) {
                    NumericField numericField = (NumericField)textField;
                    result = String.valueOf(numericField.getValue());
                } else {
                    result = textField.getText();
                }
            } else if (current instanceof TimeField) {
                Time time = ((TimeField)current).getTime();
                result = time != null ? ConversionUtilities.convertToString((Object)time) : null;
            } else if (current instanceof ComboBox) {
                result = String.valueOf(((ComboBox)current).getSelectedItem());
            } else if (current instanceof IntervalField) {
                Interval interval = ((IntervalField)current).getInterval();
                result = interval != null ? ConversionUtilities.convertToString((Object)interval) : null;
            }
            return result;
        }
    }

    static class CatalogMemberNameCellEditor
    extends TextFieldCellEditor {
        CatalogMemberNameCellEditor() {
        }

        protected void setValue(Object value) {
            CatalogMember member = (CatalogMember)value;
            super.setValue((Object)member.getName());
        }
    }

    static class CatalogMemberLabelProvider
    extends TableLabelProvider.Default<CatalogMember> {
        private final CatalogObjectTableModel model;
        private static final char BULLET = '\u2022';

        CatalogMemberLabelProvider(CatalogObjectTableModel model) {
            this.model = model;
        }

        public String getText(CatalogMember member) {
            MethodTypeDescription mtd = member.getMemberType();
            if (mtd.getParent() != null && BpmObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)mtd.asAttribute())) {
                return "  \u2022  " + mtd.getName();
            }
            return mtd.getName();
        }

        public Image getIcon(CatalogMember element) {
            if (!this.model.isRowEditable(this.getRow())) {
                return Image.create((Msg)DesignerMsg.INHERITED_MEMBER);
            }
            return null;
        }
    }
}

