/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.panel;

import oracle.bpm.designer.catalog.panel.CatalogObjectProperty;
import oracle.bpm.designer.catalog.panel.CatalogObjectTableDecorators;
import oracle.bpm.designer.catalog.panel.CatalogObjectTableModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import org.jetbrains.annotations.NotNull;

public class CatalogObjectTable
extends Table {
    private CatalogObjectTable(UiContainer parent, TableModel model) {
        super(parent, model, ListSelectionMode.SINGLE_SELECTION);
        this.setup();
    }

    public static CatalogObjectTable create(UiContainer parent, CatalogObjectTableModel model) {
        return new CatalogObjectTable(parent, (TableModel)model);
    }

    public CatalogMember getSelectedMember() {
        return (CatalogMember)this.getModel().getRow(this.getSelectedRow());
    }

    public CatalogObjectTableModel getModel() {
        return (CatalogObjectTableModel)super.getModel();
    }

    public TableColumn getColumn(@NotNull CatalogObjectProperty property) {
        return this.getColumn(property.ordinal());
    }

    private void setup() {
        this.setupColumnSizes();
        this.setupLabelProviders();
        this.setupColorProviders();
        this.setupCellEditors();
        this.setReorderingAllowed(false);
        this.getColumn(CatalogObjectProperty.PRIMARY_KEY).setImage(Image.create((Msg)DesignerMsg.ATTRIBUTE_PANEL_PK));
    }

    private void setupLabelProviders() {
        CatalogObjectTableDecorators.CatalogMemberLabelProvider memberLabelProvider = new CatalogObjectTableDecorators.CatalogMemberLabelProvider(this.getModel());
        this.getColumn(CatalogObjectProperty.NAME).setLabelProvider((LabelProvider)memberLabelProvider);
        CatalogObjectTableDecorators.TypeRefLabelProvider typeRefLabelProvider = new CatalogObjectTableDecorators.TypeRefLabelProvider();
        this.getColumn(CatalogObjectProperty.TYPE).setLabelProvider((LabelProvider)typeRefLabelProvider);
        CatalogObjectTableDecorators.DefaultValueLabelProvider defaultValueLabelProvider = new CatalogObjectTableDecorators.DefaultValueLabelProvider(this.getModel());
        this.getColumn(CatalogObjectProperty.DEFAULT_VALUE).setLabelProvider((LabelProvider)defaultValueLabelProvider);
    }

    private void setupColorProviders() {
        CatalogObjectTableDecorators.DefaultValueColorProvider defaultValueColorProvider = new CatalogObjectTableDecorators.DefaultValueColorProvider(this.getModel());
        this.getColumn(CatalogObjectProperty.DEFAULT_VALUE).setColorProvider((ColorProvider)defaultValueColorProvider);
    }

    private void setupCellEditors() {
        CatalogObjectTableDecorators.CatalogMemberNameCellEditor nameCellEditor = new CatalogObjectTableDecorators.CatalogMemberNameCellEditor();
        this.getColumn(CatalogObjectProperty.NAME).setCellEditor((TableCellEditor)nameCellEditor);
        CatalogObjectTableDecorators.DefaultValueCellEditor defaultCellEditor = new CatalogObjectTableDecorators.DefaultValueCellEditor();
        this.getColumn(CatalogObjectProperty.DEFAULT_VALUE).setCellEditor((TableCellEditor)defaultCellEditor);
        CatalogObjectTableDecorators.TypeChooserCellEditor typeCellEditor = new CatalogObjectTableDecorators.TypeChooserCellEditor(this.getModel().getComponentCatalog());
        this.getColumn(CatalogObjectProperty.TYPE).setCellEditor((TableCellEditor)typeCellEditor);
    }

    private void setupColumnSizes() {
        this.getColumn(CatalogObjectProperty.PRIMARY_KEY).setWidth(60);
        this.getColumn(CatalogObjectProperty.PRIMARY_KEY).setResizable(false);
        this.getColumn(CatalogObjectProperty.VIRTUAL).setWidth(60);
        this.getColumn(CatalogObjectProperty.VIRTUAL).setResizable(false);
        this.getColumn(CatalogObjectProperty.NOT_NULL).setWidth(60);
        this.getColumn(CatalogObjectProperty.NOT_NULL).setResizable(false);
    }
}

