/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.panel;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;

public enum CatalogObjectProperty {
    NAME(CatalogMember.class, ProjectMsg.NAME),
    PRIMARY_KEY(Boolean.class, Msg.QUOTE("")),
    VIRTUAL(Boolean.class, ProjectMsg.VIRTUAL),
    TYPE(TypeRef.class, ProjectMsg.TYPE),
    NOT_NULL(Boolean.class, DesignerMsg.NOT_NULL),
    DEFAULT_VALUE(String.class, ProjectMsg.DEFAULT_VALUE);

    private final Class<?> clazz;
    private final Msg msg;

    private CatalogObjectProperty(Class<?> clazz, Msg msg) {
        this.clazz = clazz;
        this.msg = msg;
    }

    public Class<?> getPropertyClazz() {
        return this.clazz;
    }

    public static MsgList asMessageList() {
        CatalogObjectProperty[] properties = CatalogObjectProperty.values();
        MsgList list = MsgList.create(properties.length);
        for (CatalogObjectProperty property : properties) {
            list.add(property.msg);
        }
        return list;
    }

    public static CatalogObjectProperty propertyAt(int ordinal) {
        return CatalogObjectProperty.values()[ordinal];
    }
}

