/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.panel;

import java.util.ArrayDeque;
import java.util.Deque;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.action.HideComponentAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class CatalogObjectHeaderPanel
extends Panel {
    private final CatalogObject object;

    public CatalogObjectHeaderPanel(@NotNull UiContainer parent, @NotNull CatalogObject object) {
        super(parent);
        this.object = object;
        this.buildUi();
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout());
        this.setInsets(new Margin(0, 0, 10, 0));
        CatalogObjectPathPanel path = new CatalogObjectPathPanel((UiContainer)this, this.object);
        this.add((UiComponent)path, "North");
        this.add((UiComponent)this.buildDescriptionPanel((UiContainer)this), "Center");
    }

    private Panel buildDescriptionPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new FlowLayout(0, 8, 5));
        Label label = Label.create((UiContainer)panel, (Msg)DesignerMsg.DESCRIPTION);
        panel.add((UiComponent)label);
        TextField description = new TextField((UiContainer)panel, 25);
        panel.add((UiComponent)description);
        return panel;
    }

    private static class CatalogObjectPathPanel
    extends Panel {
        CatalogObjectPathPanel(@NotNull UiContainer parent, @NotNull CatalogObject object) {
            super(parent);
            this.buildUi(object);
        }

        private static Deque<CatalogObject> getCatalogObjectPath(@NotNull CatalogObject object) {
            ArrayDeque<CatalogObject> path = new ArrayDeque<CatalogObject>();
            path.push(object);
            Object next = object;
            while (next != null) {
                next = next.getParentObject() instanceof CatalogObject ? (CatalogObject)next.getParentObject() : null;
                path.push((CatalogObject)next);
            }
            return path;
        }

        private void buildUi(@NotNull CatalogObject object) {
            this.setLayout((Layout)new FlowLayout(0, 8, 5));
            Deque<CatalogObject> stack = CatalogObjectPathPanel.getCatalogObjectPath(object);
            while (!stack.isEmpty()) {
                CatalogObject path = stack.pop();
                if (path == null) continue;
                this.addComponent(path);
                if (stack.isEmpty()) continue;
                this.addSeparator();
            }
        }

        private void addComponent(@NotNull CatalogObject object) {
            Label label = Label.create((UiContainer)this, (Msg)(Str.isEmpty(object.getId()) ? DesignerMsg.CATALOG : Msg.QUOTE(object.getName())));
            label.setIcon(this.createIcon(object));
            this.add((UiComponent)label);
        }

        private void addSeparator() {
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(">")));
        }

        private Image createIcon(@NotNull CatalogObject object) {
            TypeDescription ref = object.getDelegate();
            Image result = Str.isEmpty(object.getId()) ? Image.create((Msg)DesignerMsg.COMPONENT_GROUP) : IconFactory.getIconFor(ref);
            return HideComponentAction.isUIHidden(ref) ? result.getGrayed() : result;
        }
    }
}

