/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.introspection;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bpm.designer.catalog.introspection.ComponentWizard;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.type.Introspector;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.ui.monitor.ProgressMonitorGUI;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

class IntrospectionStepPanel
extends WizardStepPanel {
    Introspector introspector;
    private boolean errors;
    private boolean finished = false;

    public IntrospectionStepPanel(UiContainer parent, WizardStep wizardStep, Introspector introspector) {
        super(parent, wizardStep);
        this.introspector = introspector;
    }

    public boolean validateInput() {
        return true;
    }

    public boolean isStepCompleted() {
        return this.finished;
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public Dimension getMinimumSize() {
        return Dimension.valueOf(350, 200);
    }

    protected boolean needsRebuilding() {
        return true;
    }

    protected UiComponent createCenterPage(UiContainer parent) {
        this.setPageTitle(DesignerMsg.INTROSPECTING);
        this.setPageDesc(DesignerMsg.PLEASE_WAIT_INTROSPECTING);
        ProgressMonitorGUI monitor = ProgressMonitorBuilder.createAndBuildLoggingProgressMonitor((UiContainer)parent);
        monitor.setTitle(DesignerMsg.INTROSPECTING);
        monitor.progress(0);
        monitor.setListener(new ProgressMonitorGUI.Listener(){

            public void cancel() {
                IntrospectionStepPanel.this.introspector.interrupt();
            }
        });
        IntrospectionStepPanel.disableButton(this.getWizardStep().getCancelButton());
        this.introspect(monitor);
        return monitor;
    }

    protected void notifyStepReady() {
        this.finished = true;
        super.notifyStepReady();
    }

    protected boolean allowBackwardsMovement() {
        return this.errors;
    }

    protected void setErrors(boolean errors) {
        this.errors = errors;
    }

    void introspect(ProgressMonitorGUI monitor) {
    }

    List<String> getObjectConfigurationNames(ObjectTypeDescription object, ObjectTypeDescription parent) {
        ObjectTypeDescription type;
        String createdConfigs;
        ArrayList<String> configs = new ArrayList<String>();
        TypeRef typeRef = parent.findInnerType(object.getName());
        if (typeRef != null && (createdConfigs = (type = typeRef.get().asObject()).getProperty("configsCreated")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(createdConfigs, ",");
            while (tokenizer.hasMoreTokens()) {
                String configName = tokenizer.nextToken();
                configs.add(configName);
            }
        }
        return configs;
    }

    Project getProject() {
        return this.getWizard().getProject();
    }

    ComponentWizard getWizard() {
        return (ComponentWizard)this.getWizardStep().getWizard();
    }

    private static void disableButton(Button button) {
        if (button != null) {
            button.setEnabled(false);
        }
    }
}

