/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.catalog.CatalogUtils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.DescriptionEnabled;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.tree.AbstractTreeTableModel;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.treetable.TreeTableModel;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

class MemberEditorModel
extends AbstractTreeTableModel {
    private Map<TypeDescription, TypeDescription> childParentNodeMap = new Hashtable<TypeDescription, TypeDescription>();
    private Map<TypeDescription, List> hash = new Hashtable<TypeDescription, List>();
    private Msg[] names;
    private Map<Object, String> newValues;
    private ObjectTypeDescription root;
    private boolean showHidden;
    static final int NAME_COLUMN = 0;
    static final int DESCRIPTION_COLUMN = 1;
    static final int TYPE_COLUMN = 2;
    static final int PK_COLUMN = 3;

    public MemberEditorModel(ObjectTypeDescription root, boolean showHidden) {
        super((Object)root);
        this.root = root;
        this.showHidden = showHidden;
    }

    public boolean isCellEditable(Object node, int column) {
        boolean editable = column == 0;
        FuegoProject project = FuegoProject.getFrom((TypeRef)this.root);
        if (project == null) {
            return false;
        }
        boolean isReadOnly = project.createCatalogObject((TypeRef)this.root).isReadOnly();
        boolean isEditable = !this.root.isDefault();
        editable = editable || !isReadOnly && isEditable && column == 1 && this.canHaveDescription(node);
        return editable;
    }

    public Object getChild(Object parent, int index) {
        List l = this.getChilds(parent);
        if (l != null) {
            return l.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        List l = this.getChilds(parent);
        if (l != null) {
            return l.size();
        }
        return 0;
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : Object.class;
    }

    public int getColumnCount() {
        return this.getNames().length;
    }

    public String getColumnName(int column) {
        return this.getNames()[column].toString();
    }

    public boolean isDeprecated(Object value) {
        MethodTypeDescription member = null;
        if (value instanceof MethodTypeDescription) {
            member = (MethodTypeDescription)value;
        } else if (value instanceof Argument) {
            member = ((Argument)value).getParent();
        }
        return member != null && Modifier.isDeprecated(member.getModifiers());
    }

    public int getIndexOfChild(Object parent, Object child) {
        List l = this.getChilds(parent);
        if (l != null) {
            return l.indexOf(child);
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        boolean isLeaf;
        boolean bl = isLeaf = node != this.getRoot() && !(node instanceof ObjectTypeDescription);
        if (node instanceof MethodTypeDescription && ((MethodTypeDescription)node).isMethod()) {
            isLeaf = isLeaf && ((MethodTypeDescription)node).getArgumentCount() == 0;
        }
        return isLeaf;
    }

    public String getNodeText(Object value) {
        Object val = this.getValueAt(value, 0, true);
        return val != null ? val.toString() : "xx";
    }

    public boolean isNodeVisible(Object value) {
        if (value instanceof MethodTypeDescription) {
            return ((MethodTypeDescription)value).isVisible();
        }
        if (value instanceof Argument) {
            return ((Argument)value).getParent().isVisible();
        }
        return true;
    }

    public Object getParent(Object node) {
        return null;
    }

    public Object getRoot() {
        return this.root;
    }

    public void applyChanges() {
        if (this.newValues != null) {
            for (Object key : this.newValues.keySet()) {
                if (!(key instanceof DescriptionEnabled)) continue;
                ((DescriptionEnabled)key).setDescription(this.newValues.get(key));
            }
            this.newValues = null;
        }
    }

    public void setValueAt(Object aValue, Object node, int column) {
        if (node instanceof MethodTypeDescription) {
            MethodTypeDescription memberDescrip = (MethodTypeDescription)node;
            switch (column) {
                case 0: {
                    break;
                }
                case 1: {
                    this.addUndoable(memberDescrip, (String)aValue);
                    break;
                }
            }
        } else if (node instanceof ObjectTypeDescription) {
            TypeDescription td = (TypeDescription)node;
            switch (column) {
                case 0: {
                    break;
                }
                case 1: {
                    this.addUndoable(td.asObject(), (String)aValue);
                    break;
                }
            }
        } else if (node instanceof Argument && column == 1) {
            Argument argument = (Argument)node;
            this.addUndoable(argument, (String)aValue);
        }
    }

    public Object getValueAt(Object node, int column, boolean string) {
        if (column == 1 && this.newValues != null && this.newValues.containsKey(node)) {
            return this.newValues.get(node);
        }
        TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
        if (node instanceof MethodTypeDescription) {
            MethodTypeDescription member = (MethodTypeDescription)node;
            switch (column) {
                case 0: {
                    return string ? member.getName() : member;
                }
                case 1: {
                    return member.getDescription();
                }
                case 2: {
                    return renderer.render((TypeRef)member.getResultType());
                }
                case 3: {
                    return member.isAttribute() && member.asAttribute().isPrimaryKey() ? CoreMsg.YES : CoreMsg.NO;
                }
            }
        } else if (node instanceof XFormPresentationModel) {
            XFormPresentationModel pres = (XFormPresentationModel)node;
            switch (column) {
                case 0: {
                    return string ? pres.getPresentationName() : pres;
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return CoreMsg.NO;
                }
            }
        } else if (node instanceof ObjectTypeDescription) {
            TypeDescription td = (TypeDescription)node;
            switch (column) {
                case 0: {
                    return string ? td.getName() : td;
                }
                case 1: {
                    return td.asObject().getDescription();
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return CoreMsg.NO;
                }
            }
        } else if (node instanceof Argument) {
            Argument argument = (Argument)node;
            switch (column) {
                case 0: {
                    return string ? argument.getName() : argument;
                }
                case 1: {
                    return argument.getDescription();
                }
                case 2: {
                    return renderer.render(argument.getTypeRef());
                }
                case 3: {
                    return CoreMsg.NO;
                }
            }
        }
        return null;
    }

    public Object getValueAt(Object node, int column) {
        return this.getValueAt(node, column, false);
    }

    public void refresh() {
        this.hash = new Hashtable<TypeDescription, List>();
        this.childParentNodeMap = new HashMap<TypeDescription, TypeDescription>();
        this.fireTreeStructureChanged();
    }

    public Msg[] getNames() {
        if (this.names == null) {
            this.names = new Msg[]{ProjectDrawMsg.NAME, DesignerMsg.DESCRIPTION, DesignerMsg.TYPE, DesignerMsg.ATTRIBUTE_PANEL_PK};
        }
        return this.names;
    }

    public boolean isMemberInherited(TypeDescription td) {
        if (td.getParent() instanceof ObjectTypeDescription) {
            ObjectTypeDescription parent = (ObjectTypeDescription)td.getParent();
            TypeDescription parentNode = this.childParentNodeMap.get(td);
            return parentNode != null && !parentNode.equals(parent);
        }
        return false;
    }

    protected void fireTreeStructureChanged() {
        this.fireTreeStructureChanged((Object)this, TreePath.createSinglePath((Object)this.root).getPath(), null, null);
    }

    private List getChilds(Object typeDescription) {
        TypeDescription parent = (TypeDescription)typeDescription;
        if (!this.hash.containsKey(parent)) {
            this.load(parent, this.showHidden);
        }
        return this.hash.get(parent);
    }

    private void addUndoable(Object descriptable, String newDescription) {
        if (this.newValues == null) {
            this.newValues = new HashMap<Object, String>();
        }
        this.newValues.put(descriptable, newDescription);
    }

    private boolean canHaveDescription(Object node) {
        return node instanceof DescriptionEnabled;
    }

    private void load(Object parent, boolean doShowHidden) {
        if (parent instanceof ObjectTypeDescription) {
            this.load((ObjectTypeDescription)parent, doShowHidden, true);
        } else if (parent instanceof MethodTypeDescription) {
            this.load((MethodTypeDescription)parent);
        }
    }

    private void load(MethodTypeDescription mtd) {
        List<Argument> list = ArrayUtils.asList(mtd.getArguments());
        if (mtd.getResultType() != TypeFactory.getVoid()) {
            list.add(mtd.getResultArgument());
        }
        this.hash.put(mtd, list);
    }

    private void load(ObjectTypeDescription td, boolean doShowHidden, boolean showInherited) {
        ArrayList<Object> membersList = new ArrayList<Object>();
        for (MethodTypeDescription method : td.getMethods()) {
            for (MethodTypeDescription overloaded : method.overloaded()) {
                if (!doShowHidden && !overloaded.isVisible()) continue;
                membersList.add(overloaded);
                this.childParentNodeMap.put(overloaded, td);
            }
        }
        for (MethodTypeDescription current : td.getMembers(18, 0L, 0x2000000L)) {
            if (!doShowHidden && !current.isVisible()) continue;
            membersList.add(current);
            this.childParentNodeMap.put(current, td);
        }
        if (showInherited) {
            this.loadParentMembers(td, membersList);
        }
        int c = td.getInnerTypeCount();
        for (int i = 0; i < c; ++i) {
            membersList.add(td.getInnerType(i));
        }
        if (td instanceof XObjectTypeDescription) {
            XFormPresentationModel[] pmodel = ((XObjectTypeDescription)td).getPModels();
            membersList.addAll(Arrays.asList(pmodel));
        }
        this.hash.put(td, membersList);
    }

    private void loadParentMembers(ObjectTypeDescription otd, List<Object> list) {
        ArrayList<MethodTypeDescription[]> parentMembersList = new ArrayList<MethodTypeDescription[]>();
        this.addParentMembersToList(otd, parentMembersList);
        ArrayList<MethodTypeDescription[][]> parentMembersGroupsList = new ArrayList<MethodTypeDescription[][]>();
        for (MethodTypeDescription[] parentMembers : parentMembersList) {
            MethodTypeDescription[][] parentMembersGroups = new MethodTypeDescription[parentMembers.length][0];
            this.fillMembers(parentMembers, parentMembersGroups);
            parentMembersGroupsList.add(parentMembersGroups);
        }
        Iterator it = parentMembersList.iterator();
        int count = 0;
        while (it.hasNext()) {
            MethodTypeDescription[] parentMembers = (MethodTypeDescription[])it.next();
            MethodTypeDescription[][] parentMembersGroups = (MethodTypeDescription[][])parentMembersGroupsList.get(count);
            for (int i = 0; i < parentMembers.length; ++i) {
                MethodTypeDescription mtd = parentMembers[i];
                list.add(mtd);
                this.childParentNodeMap.put(mtd, otd);
                for (int j = 0; j < parentMembersGroups[i].length; ++j) {
                    MethodTypeDescription parentMember = parentMembersGroups[i][j];
                    list.add(parentMember);
                    this.childParentNodeMap.put(parentMember, otd);
                }
            }
            ++count;
        }
    }

    private void addParentMembersToList(TypeDescription td, List<MethodTypeDescription[]> parentMembersList) {
        for (ObjectTypeDescription parent : CatalogUtils.getVisibleSuperTypes(td)) {
            this.addParentMembersToList(parent, parentMembersList);
            parentMembersList.add(0, this.getSortedAttributeList(parent));
        }
    }

    private MethodTypeDescription[] getSortedAttributeList(ObjectTypeDescription object) {
        if (object == null) {
            return new MethodTypeDescription[0];
        }
        MethodTypeDescription[] array = object.getMembers(18, 0L, 0x2000000L);
        Arrays.sort(array, ObjectTypeDescription.ATTRIBUTE_BY_POSITION_COMPARATOR);
        return array;
    }

    private int fillMembers(MethodTypeDescription[] members, MethodTypeDescription[][] memberGroups) {
        int totalCount = 0;
        for (int i = 0; i < members.length; ++i) {
            if (!XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)members[i].asAttribute())) continue;
            ObjectTypeDescription innerType = members[i].getResultType().getElementType().asObject();
            memberGroups[i] = this.getSortedAttributeList(innerType);
            totalCount += memberGroups[i].length;
        }
        return totalCount;
    }
}

