/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.precision;

import java.util.ArrayList;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.AbstractPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class IntPrecisionPanel
extends AbstractPrecisionPanel {
    private boolean eventsEnabled = true;
    private ComboBox<Integer> precisionCombo;
    private static int DEFAULT_LENGTH = 2;

    public IntPrecisionPanel(PrecisionPanel parentPanel, PrecisionMediator precisionMediator) {
        super(parentPanel, precisionMediator);
        this.initGui();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.precisionCombo.setEnabled(enabled);
    }

    @Override
    public int getPrecision() {
        return (Integer)this.precisionCombo.getSelectedItem();
    }

    @Override
    public boolean isPrecisionSet() {
        return true;
    }

    @Override
    public void clear() {
        this.precisionCombo.setSelectedIndex(DEFAULT_LENGTH);
    }

    @Override
    public void deselectPrecision() {
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        int length = attribute.asAttribute().getType().getLength();
        int index = DEFAULT_LENGTH;
        switch (length) {
            case 8: {
                index = 0;
                break;
            }
            case 16: {
                index = 1;
                break;
            }
            case 32: {
                index = 2;
                break;
            }
            case 64: {
                index = 3;
            }
        }
        this.eventsEnabled = false;
        this.precisionCombo.setSelectedIndex(index);
        this.eventsEnabled = true;
    }

    private void buildCombo() {
        ArrayList<Integer> precisions = new ArrayList<Integer>();
        precisions.add(8);
        precisions.add(16);
        precisions.add(32);
        precisions.add(64);
        this.precisionCombo = UiFactory.createComboBox((UiContainer)this, precisions);
        this.precisionCombo.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
        this.precisionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected() && IntPrecisionPanel.this.eventsEnabled) {
                    IntPrecisionPanel.this.getPrecisionMediator().intPrecisionChanged(IntPrecisionPanel.this.getPrecision());
                }
            }
        });
        this.precisionCombo.setToolTipMsg(DesignerMsg.INT_LENGTH_TOOLTIP);
    }

    private void initGui() {
        String cols = "2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu";
        String rows = "3dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        Label precisionLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.INT_PRECISION);
        precisionLabel.setToolTipText(DesignerMsg.INT_LENGTH_TOOLTIP.getString());
        builder.add((UiComponent)precisionLabel, cc.xy(2, 2));
        this.buildCombo();
        builder.add(this.precisionCombo, cc.xy(4, 2));
    }
}

