/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.precision;

import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.AbstractPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;

class DecimalPrecisionPanel
extends AbstractPrecisionPanel {
    private CheckBox decimalDigitsCheck;
    private NumericField<Integer> decimalDigitsSpinner;
    private NumericField<Integer> decimalLengthDigitsSpinner;
    private Label fractionLabel;
    private boolean isUnselectingPrecision = false;
    private Label lengthLabel;
    private boolean loading = false;

    public DecimalPrecisionPanel(PrecisionPanel parentPanel, PrecisionMediator precisionMediator) {
        super(parentPanel, precisionMediator);
        this.initGui();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.decimalDigitsCheck.setEnabled(enabled);
        boolean enable = enabled && this.decimalDigitsCheck.isSelected();
        this.decimalDigitsSpinner.setEnabled(enable);
        this.decimalLengthDigitsSpinner.setEnabled(enable);
        this.lengthLabel.setEnabled(enable);
        this.fractionLabel.setEnabled(enable);
    }

    @Override
    public int getPrecision() {
        return (Integer)this.decimalDigitsSpinner.getValue();
    }

    @Override
    public boolean isPrecisionSet() {
        return this.decimalDigitsCheck.isSelected();
    }

    @Override
    public void clear() {
        this.decimalDigitsCheck.setSelected(false);
        this.decimalDigitsSpinner.setValue((Number)2);
        this.decimalLengthDigitsSpinner.setValue((Number)4);
    }

    @Override
    public void deselectPrecision() {
        this.isUnselectingPrecision = true;
        this.decimalDigitsCheck.setSelected(false);
        this.decimalDigitsSpinner.setEnabled(false);
        this.decimalLengthDigitsSpinner.setEnabled(false);
        this.lengthLabel.setEnabled(false);
        this.fractionLabel.setEnabled(false);
        this.clear();
        this.isUnselectingPrecision = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        this.loading = true;
        try {
            boolean isScaleSet;
            int scale = attribute.getResultType().getScale();
            int length = attribute.getResultType().getLength();
            boolean bl = isScaleSet = scale != -1;
            if (!isScaleSet) {
                this.deselectPrecision();
            } else {
                boolean shouldEnable = super.isEnabled();
                this.decimalDigitsCheck.setSelected(true);
                this.decimalDigitsSpinner.setEnabled(shouldEnable);
                this.fractionLabel.setEnabled(shouldEnable);
                this.decimalDigitsSpinner.setValue((Number)scale);
                this.decimalLengthDigitsSpinner.setEnabled(shouldEnable);
                this.lengthLabel.setEnabled(shouldEnable);
                this.decimalLengthDigitsSpinner.setValue((Number)length);
            }
        }
        finally {
            this.loading = false;
        }
    }

    private void buildScaleCheck() {
        this.decimalDigitsCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.DECIMAL_PRECISION.withColon());
        this.decimalDigitsCheck.setBackground(Color.WHITE);
        this.decimalDigitsCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean enable = DecimalPrecisionPanel.this.decimalDigitsCheck.isSelected() && DecimalPrecisionPanel.this.isEnabled();
                DecimalPrecisionPanel.this.decimalDigitsSpinner.setEnabled(enable);
                DecimalPrecisionPanel.this.decimalLengthDigitsSpinner.setEnabled(enable);
                DecimalPrecisionPanel.this.lengthLabel.setEnabled(enable);
                DecimalPrecisionPanel.this.fractionLabel.setEnabled(enable);
                if (!DecimalPrecisionPanel.this.loading && !DecimalPrecisionPanel.this.isUnselectingPrecision) {
                    DecimalPrecisionPanel.this.changeScaleAndLength();
                }
            }
        });
        this.decimalDigitsCheck.setToolTipText(DesignerMsg.DECIMAL_DIGITS_CHECK_TOOLTIP.getString());
    }

    private void buildScaleSpinner() {
        this.decimalDigitsSpinner = NumericField.createIntegerNumericField((UiContainer)this);
        this.decimalDigitsSpinner.setValue((Number)1);
        this.decimalDigitsSpinner.setRange((Number)0, (Number)((Integer)this.decimalLengthDigitsSpinner.getMaximum() - 1));
        this.decimalDigitsSpinner.setStepSize((Number)1);
        this.decimalDigitsSpinner.setEnabled(false);
        this.decimalDigitsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!DecimalPrecisionPanel.this.loading && !DecimalPrecisionPanel.this.isUnselectingPrecision) {
                    DecimalPrecisionPanel.this.changeScaleAndLength();
                }
            }
        });
        this.decimalDigitsSpinner.setToolTipText(DesignerMsg.DECIMAL_DIGITS_TOOLTIP.getString());
    }

    private void buildLengthSpinner() {
        this.decimalLengthDigitsSpinner = NumericField.createIntegerNumericField((UiContainer)this);
        this.decimalLengthDigitsSpinner.setValue((Number)4);
        this.decimalLengthDigitsSpinner.setRange((Number)1, (Number)100);
        this.decimalLengthDigitsSpinner.setStepSize((Number)1);
        this.decimalLengthDigitsSpinner.setEnabled(false);
        this.decimalLengthDigitsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Integer length = (Integer)DecimalPrecisionPanel.this.decimalLengthDigitsSpinner.getValue();
                if ((Integer)DecimalPrecisionPanel.this.decimalDigitsSpinner.getValue() >= length) {
                    boolean oldLoading = DecimalPrecisionPanel.this.loading;
                    DecimalPrecisionPanel.this.loading = true;
                    DecimalPrecisionPanel.this.decimalDigitsSpinner.setValue((Number)(length - 1));
                    DecimalPrecisionPanel.this.loading = oldLoading;
                }
                DecimalPrecisionPanel.this.decimalDigitsSpinner.setMaximum((Number)(length - 1));
                if (!DecimalPrecisionPanel.this.loading && !DecimalPrecisionPanel.this.isUnselectingPrecision) {
                    DecimalPrecisionPanel.this.changeScaleAndLength();
                }
            }
        });
        this.decimalLengthDigitsSpinner.setToolTipText(DesignerMsg.DECIMAL_DIGITS_TOOLTIP.getString());
    }

    private void changeScaleAndLength() {
        int scale = -1;
        int length = -1;
        if (this.decimalDigitsCheck.isSelected()) {
            length = (Integer)this.decimalLengthDigitsSpinner.getValue();
            scale = (Integer)this.decimalDigitsSpinner.getValue();
        }
        this.getPrecisionMediator().decimalPrecisionChanged(scale, length);
    }

    private void initGui() {
        String cols = "6dlu, pref, 2dlu, pref, 2dlu, pref, 1dlu, pref, 1dlu, pref, 2dlu, pref, 1dlu, pref";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.buildScaleCheck();
        builder.add((UiComponent)this.decimalDigitsCheck, cc.xy(2, 1));
        this.buildLengthSpinner();
        this.lengthLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TOTAL_DIGITS);
        this.lengthLabel.setEnabled(false);
        builder.add((UiComponent)this.lengthLabel, cc.xy(4, 1));
        builder.add(this.decimalLengthDigitsSpinner, cc.xy(6, 1));
        this.buildScaleSpinner();
        this.fractionLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.FRACTION_DIGITS);
        this.fractionLabel.setEnabled(false);
        builder.add((UiComponent)this.fractionLabel, cc.xy(8, 1));
        builder.add(this.decimalDigitsSpinner, cc.xy(10, 1));
    }
}

