/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.highlighters;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.highlighters.DefaultHighlighter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.text.TextField;

public class TextFieldHighlighter
extends DefaultHighlighter {
    private Border defaultBorder;
    private TextField textField;

    public TextFieldHighlighter() {
    }

    public TextFieldHighlighter(Color highlightColor) {
        super(highlightColor);
    }

    @Override
    public void setComponentToHightlight(UiComponent component) {
        this.setTextField((TextField)component);
    }

    public void setTextField(TextField textField) {
        this.textField = textField;
        this.defaultBorder = textField.getBorder();
        textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (TextFieldHighlighter.this.doHighlight) {
                    TextFieldHighlighter.this.highLight();
                }
            }
        });
        textField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (TextFieldHighlighter.this.doHighlight) {
                    TextFieldHighlighter.this.highLight();
                }
            }
        });
    }

    @Override
    public void highLight(boolean enableHightlight) {
        if (this.textField.isEnabled()) {
            boolean highlight = enableHightlight && (this.textField.getText() == null || this.textField.getText().equals("") && !this.allowEmptyString);
            this.currentBorder = highlight ? this.highlightBorder : this.defaultBorder;
            String tooltip = highlight ? DesignerMsg.NULL_NOT_ALLOWED_WARNING.getString() : DesignerMsg.DEFAULT_VALUE_TOOLTIP.getString();
            this.textField.setToolTipText(tooltip);
            this.highlightTextField(highlight);
        }
    }

    private void highlightTextField(boolean highlight) {
        if (!highlight) {
            this.textField.setBorder(null);
        }
        this.textField.setBorder(this.currentBorder);
    }
}

