/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues;

import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentEditorProvider;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.AbstractHighlightableValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.highlighters.TimeFieldHightlighter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.util.XObjectValueResolver;

class TimeValuePanel
extends AbstractHighlightableValuePanel {
    private MethodTypeDescription attribute;
    private Time oldTime;
    private TimeField timeField;

    public TimeValuePanel(UiContainer parent) {
        super(parent);
        this.setLayout((Layout)new FlowLayout(0));
        this.initGui();
    }

    @Override
    public String getDefaultValue() {
        Time time = this.timeField.getTime();
        return time != null ? ConversionUtilities.convertToString((Object)time) : null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.timeField.setEnabled(enabled);
    }

    public void addChangeListener(FuegoObjectAttributePropertiesPanel panel) {
        panel.addListener((UiComponent)this.timeField);
    }

    @Override
    public void clear() {
        this.timeField.setTime(new Time());
    }

    public TimeField getTimeField() {
        return this.timeField;
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        this.attribute = attribute;
        this.oldTime = null;
        String defaultValue = this.getAttribute().getDefaultValue();
        Time defaultTimeValue = Time.now();
        try {
            if (defaultValue != null && !defaultValue.equals("")) {
                XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)6);
                defaultTimeValue = (Time)setter.getValueFromString(defaultValue);
            }
        }
        catch (TimeFormatException tfe) {
            defaultTimeValue = Time.now();
        }
        int precision = this.getAttribute().getPrecision();
        defaultTimeValue = this.formatPrecision(precision, defaultTimeValue);
        this.timeField.setTime(defaultTimeValue);
        TimeField.Style style = ComponentEditorProvider.getStyle(precision);
        this.timeField.setStyle(style);
    }

    public AttributeTypeDescription getAttribute() {
        return this.attribute.asAttribute();
    }

    public void precisionChanged(int length, int timePrecision) {
        Time time = this.timeField.getTime();
        time = this.formatPrecision(timePrecision, time);
        this.timeField.setTime(time);
        this.repaint();
    }

    private Time formatPrecision(int index, Time currentTime) {
        switch (index) {
            case 0: {
                this.oldTime = this.timeField.getTime();
                return Time.valueOf(currentTime.getYear(), currentTime.getMonth(), currentTime.getDayOfMonth(), 0, 0, 0, 0);
            }
            case 1: {
                this.oldTime = this.timeField.getTime();
                Time now = Time.now();
                return Time.valueOf(now.getYear(), now.getMonth(), now.getDayOfMonth(), currentTime.getHourOfDay(), currentTime.getMinute(), currentTime.getSecond(), 0);
            }
        }
        if (this.oldTime != null) {
            currentTime = this.oldTime;
        }
        return Time.valueOf(currentTime.getYear(), currentTime.getMonth(), currentTime.getDayOfMonth(), currentTime.getHourOfDay(), currentTime.getMinute(), currentTime.getSecond(), 0);
    }

    private void initGui() {
        this.timeField = new TimeField((UiContainer)this){

            public void setToolTipText(String text) {
                super.setToolTipText(text);
                TimeValuePanel.this.setToolTipText(text);
            }
        };
        this.timeField.setTime(Time.now());
        this.timeField.setToolTipText(DesignerMsg.DEFAULT_VALUE_TOOLTIP.getString());
        this.setExactSize(Dimension.valueOf(250, 15));
        this.add((UiComponent)this.timeField);
        this.highlighter = new TimeFieldHightlighter();
        this.highlighter.setComponentToHightlight((UiComponent)this.timeField);
    }
}

