/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues;

import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.AbstractValuePanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;

class BooleanValuePanel
extends AbstractValuePanel {
    private ComboBox combo;
    private static final Boolean DEFAULT_SELECTED_VALUE = Boolean.FALSE;

    BooleanValuePanel(UiContainer parent) {
        super(parent);
        this.initGui();
    }

    @Override
    public String getDefaultValue() {
        Object value = this.combo.getSelectedItem();
        return value == null ? "" : value.toString();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.combo.setEnabled(enabled);
    }

    public void addChangeListener(FuegoObjectAttributePropertiesPanel panel) {
        panel.addListener(this.combo);
    }

    @Override
    public void clear() {
        this.combo.setSelectedItem((Object)DEFAULT_SELECTED_VALUE);
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        String defaultValue = attribute.asAttribute().getDefaultValue();
        if (defaultValue.equals("true")) {
            this.combo.setSelectedIndex(0);
        } else {
            this.combo.setSelectedIndex(1);
        }
    }

    private void initGui() {
        this.combo = UiFactory.createBooleanComboBox((UiContainer)this);
        this.combo.setSelectedItem((Object)DEFAULT_SELECTED_VALUE);
        Dimension dimension = Dimension.valueOf(100, 20);
        this.combo.setPreferredSize(dimension);
        this.combo.setBackground(Color.WHITE);
        this.combo.setToolTipMsg(DesignerMsg.DEFAULT_VALUE_TOOLTIP);
        this.add((UiComponent)this.combo);
        this.setMinimumSize(dimension);
    }
}

