/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import oracle.bpm.designer.ComponentStructureAbstractPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class TypePanel
extends Panel {
    private MethodTypeDescription attribute;
    private boolean eventsEnabled;
    private ObjectTypeDescription objectType;
    private PrecisionMediator precisionMediator;
    private PrecisionPanel precisionPanel;
    private boolean readOnly;
    private TypeChooserPanel typeChooserPanel;

    public TypePanel(UiContainer parent, ObjectTypeDescription objectType, boolean readOnly, PrecisionMediator precisionMediator, FuegoObjectAttributePropertiesPanel fuegoObjectAttributePropertiesPanel) {
        super(parent);
        this.readOnly = readOnly;
        this.precisionMediator = precisionMediator;
        this.eventsEnabled = false;
        this.objectType = objectType;
        this.initGui();
        this.eventsEnabled = true;
    }

    public void setAttribute(MethodTypeDescription attribute) {
        this.eventsEnabled = false;
        this.attribute = attribute;
        this.typeChooserPanel.setInitialType(CatalogObjectImpl.get((TypeRef)attribute.getResultType()), false);
        this.precisionPanel.loadAttribute(attribute);
        this.eventsEnabled = true;
    }

    public void setEnabled(boolean enabled) {
        assert (!this.isDisposed()) : "TypePanel was disposed";
        this.typeChooserPanel.setEnabled(enabled);
        this.precisionPanel.setEnabled(enabled);
    }

    public UiComponent getFirstComponent() {
        return this.typeChooserPanel;
    }

    public int getPrecision() {
        return this.precisionPanel.getPrecision();
    }

    public boolean isFuegoObject() {
        if (this.attribute == null) {
            return false;
        }
        TypeDescription type = this.attribute.getResultType();
        if (type == null) {
            return false;
        }
        if (type.isArray()) {
            type = type.getElementType();
        }
        return type.isBpmObject();
    }

    public boolean isPrecisionSet() {
        return this.precisionPanel.isPrecisionSet();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void addChangeListener(ComponentStructureAbstractPanel panel) {
        panel.addListener(this.typeChooserPanel);
    }

    public void realoadStringLength(int length) {
        TypeDescription type = this.attribute.getResultType().setLength(length);
        this.attribute.setResultType(type);
        this.reloadTypePrecision(type);
    }

    public void reloadTimePrecision(int precision) {
        this.attribute.asAttribute().setPrecision(precision);
    }

    public void reloadType(MethodTypeDescription attribute, boolean typeChanged) {
        this.precisionPanel.loadAttribute(attribute);
    }

    public void reloadTypeLength(int newLength) {
        TypeDescription type = this.attribute.getResultType().setLength(newLength);
        this.reloadTypePrecision(type);
    }

    public void reloadTypePrecision(int scale) {
        TypeDescription type = this.attribute.getResultType().setScale(scale);
        this.attribute.setResultType(type);
        this.eventsEnabled = false;
        this.typeChooserPanel.setInitialType(CatalogObjectImpl.get((TypeRef)this.attribute.getResultType()), false);
        this.eventsEnabled = true;
    }

    public void reloadTypeScale(int newScale) {
        int length = this.attribute.getResultType().getLength();
        this.reloadTypeScaleAndLength(newScale, length);
    }

    public void reloadTypeScaleAndLength(int newScale, int newLength) {
        TypeDescription type = this.attribute.getResultType().setScale(newScale);
        this.attribute.setResultType(type);
        type = this.attribute.getResultType().setLength(newLength);
        this.reloadTypePrecision(type);
    }

    private CheckBox buildIncludeInCheck(UiContainer parent) {
        CheckBox isIncludeInCheck = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.IS_INCLUDE_IN_CHECK);
        isIncludeInCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
            }
        });
        isIncludeInCheck.setToolTipText(DesignerMsg.INCLUDE_IN_CHECK_TOOLTIP.getString());
        if (!this.isFuegoObject()) {
            isIncludeInCheck.setSelected(true);
            isIncludeInCheck.setEnabled(false);
            isIncludeInCheck.setVisible(false);
        }
        return isIncludeInCheck;
    }

    private MutableComponentCatalog getTypeRepository() {
        return (MutableComponentCatalog)this.objectType.getCatalog();
    }

    private void initTypeChooserPanel() {
        if (this.typeChooserPanel == null) {
            this.typeChooserPanel = TypeChooserPanel.create((UiContainer)this, this.getTypeRepository());
            TypeChooserPanel.EnsuredItemListener<CatalogType> listener = new TypeChooserPanel.EnsuredItemListener<CatalogType>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(TypeChooserPanel.EnsuredItemEvent<CatalogType> event) {
                    if (TypePanel.this.eventsEnabled) {
                        try {
                            boolean typeChanged;
                            TypePanel.this.eventsEnabled = false;
                            CatalogType selectedType = event.getItem();
                            boolean bl = typeChanged = TypePanel.this.attribute.getResultType().getKind() != selectedType.getKind();
                            if (!TypePanel.this.attribute.asAttribute().getType().equals(selectedType)) {
                                TypePanel.this.attribute.asAttribute().setDefaultValue(null);
                            }
                            TypePanel.this.attribute.asAttribute().setType(selectedType.getDynamicRef());
                            TypePanel.this.reloadType(TypePanel.this.attribute, typeChanged);
                        }
                        finally {
                            TypePanel.this.eventsEnabled = true;
                        }
                    }
                }
            };
            this.typeChooserPanel.addTypedItemListener(listener);
        }
    }

    private void initGui() {
        String cols = "2dlu, pref, 2dlu, pref:grow, 10dlu, pref, 2dlu, pref, fill:2dlu:grow";
        String rows = "2dlu, pref, 3dlu, pref, 3dlu, pref, 1dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.initTypeChooserPanel();
        this.typeChooserPanel.setEnabled(!this.isReadOnly());
        this.precisionPanel = new PrecisionPanel((UiContainer)this, this.isReadOnly(), this.precisionMediator);
        builder.add((UiComponent)new SeparatorPanel((UiContainer)this, CoreMsg.TYPE), cc.xywh(2, 2, 8, 1));
        builder.add((UiComponent)this.typeChooserPanel, cc.xy(2, 4));
        builder.add((UiComponent)this.precisionPanel, cc.xy(6, 4));
    }

    private void reloadTypePrecision(TypeRef type) {
        this.eventsEnabled = false;
        this.attribute.setResultType(type);
        this.typeChooserPanel.setInitialType(CatalogObjectImpl.get((TypeRef)type.get()), true);
        this.eventsEnabled = true;
    }
}

