/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import java.math.BigDecimal;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.highlighters.IntervalFieldHighlighter;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.xobject.util.XObjectValueResolver;

public class ComponentEditorProvider {
    public static final int MAXIMUM_INT_LENGTH = 180;
    public static final int MAXIMUM_DECIMAL_DECIMAL_PLACES = 0;
    public static final int DECIMAL_MAXIMUM_LENGTH = 180;
    public static final int MAX_REAL_DECIMAL_PLACES = 9;
    public static final int MAX_REAL_LENGTH = 180;

    private ComponentEditorProvider() {
    }

    public static UiComponent getEditor(UiContainer parent, int type, int restrictions, String textToSet) {
        TextField result;
        switch (type) {
            case 2: {
                result = ComponentEditorProvider.getIntField(parent, restrictions, textToSet);
                break;
            }
            case 3: {
                result = ComponentEditorProvider.getDecimalComponent(parent, restrictions, textToSet);
                break;
            }
            case 4: {
                result = ComponentEditorProvider.getRealComponent(parent, textToSet);
                break;
            }
            case 5: {
                result = ComponentEditorProvider.getStringComponent(parent, restrictions, textToSet);
                break;
            }
            case 7: {
                result = ComponentEditorProvider.getIntervalComponent(parent, textToSet);
                break;
            }
            case 6: {
                result = ComponentEditorProvider.getTimeComponent(parent, restrictions, textToSet);
                break;
            }
            case 1: {
                result = ComponentEditorProvider.getBooleanComponent(parent, textToSet);
                break;
            }
            default: {
                result = ComponentEditorProvider.getDefaultComponent(parent, textToSet);
            }
        }
        return result;
    }

    public static UiComponent getEditor(UiContainer parent, int type, String textToSet) {
        return ComponentEditorProvider.getEditor(parent, type, -1, textToSet);
    }

    public static UiComponent getEditor(UiContainer parent, int type, int restrictions, Object value) {
        TimeField result;
        switch (type) {
            case 2: {
                result = ComponentEditorProvider.getIntField(parent, restrictions, value);
                break;
            }
            case 3: {
                result = ComponentEditorProvider.getDecimalComponent(parent, restrictions, value);
                break;
            }
            case 4: {
                result = ComponentEditorProvider.getRealComponent(parent, value);
                break;
            }
            case 5: {
                result = ComponentEditorProvider.getStringComponent(parent, restrictions, (String)value);
                break;
            }
            case 7: {
                result = ComponentEditorProvider.getIntervalComponent(parent, value);
                break;
            }
            case 6: {
                result = ComponentEditorProvider.getTimeComponent(parent, restrictions, value);
                break;
            }
            case 1: {
                result = ComponentEditorProvider.getBooleanComponent(parent, value);
                break;
            }
            default: {
                result = ComponentEditorProvider.getDefaultComponent(parent, value.toString());
            }
        }
        return result;
    }

    public static Time formatPresition(int type, Time currentTime) {
        switch (type) {
            case 0: {
                return Time.valueOf(currentTime.getYear(), currentTime.getMonth(), currentTime.getDayOfMonth(), 0, 0, 0, 0);
            }
            case 1: {
                Time now = Time.now();
                return Time.valueOf(now.getYear(), now.getMonth(), now.getDayOfMonth(), currentTime.getHourOfDay(), currentTime.getMinute(), currentTime.getSecond(), 0);
            }
        }
        return Time.valueOf(currentTime.getYear(), currentTime.getMonth(), currentTime.getDayOfMonth(), currentTime.getHourOfDay(), currentTime.getMinute(), currentTime.getSecond(), 0);
    }

    public static TimeField.Style getStyle(int restrictions) {
        TimeField.Style style;
        switch (restrictions) {
            case 0: {
                style = TimeField.Style.DATE;
                break;
            }
            case 1: {
                style = TimeField.Style.TIME;
                break;
            }
            default: {
                style = TimeField.Style.DATE_TIME;
            }
        }
        return style;
    }

    private static ComboBox<Boolean> getBooleanComponent(UiContainer parent, String textToSet) {
        return ComponentEditorProvider.getBooleanComponent(parent, textToSet, null);
    }

    private static ComboBox<Boolean> getBooleanComponent(UiContainer parent, Object value) {
        return ComponentEditorProvider.getBooleanComponent(parent, null, value);
    }

    private static ComboBox<Boolean> getBooleanComponent(UiContainer parent, String textToSet, Object value) {
        ComboBox booleanCheck = UiFactory.createBooleanComboBox((UiContainer)parent);
        if (value != null) {
            booleanCheck.setSelectedItem(value);
        } else {
            booleanCheck.setSelectedItem((Object)Boolean.valueOf(textToSet));
        }
        return booleanCheck;
    }

    private static NumericField<BigDecimal> getDecimalComponent(UiContainer parent, int restrictions, String textToSet) {
        return ComponentEditorProvider.getDecimalComponent(parent, restrictions, textToSet, null);
    }

    private static NumericField<BigDecimal> getDecimalComponent(UiContainer parent, int restrictions, Object value) {
        return ComponentEditorProvider.getDecimalComponent(parent, restrictions, null, value);
    }

    private static NumericField<BigDecimal> getDecimalComponent(UiContainer parent, int restrictions, String textToSet, Object value) {
        NumericField decimalField = NumericField.createBigDecimalNumericField((UiContainer)parent);
        if (restrictions >= 0) {
            decimalField.setScale(restrictions);
        }
        if (value != null) {
            decimalField.setValue((Number)((BigDecimal)value));
        } else {
            XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)3);
            decimalField.setValue((Number)(textToSet != null ? (BigDecimal)setter.getValueFromString(textToSet) : (BigDecimal)setter.getDefaultValue()));
        }
        return decimalField;
    }

    private static TextField getDefaultComponent(UiContainer parent, String textToSet) {
        TextField defaultTextField = new TextField(parent);
        defaultTextField.setText(textToSet);
        return defaultTextField;
    }

    private static NumericField<Integer> getIntField(UiContainer parent, int restrictions, Object value) {
        return ComponentEditorProvider.getIntField(parent, restrictions, null, value);
    }

    private static NumericField<Integer> getIntField(UiContainer parent, int restrictions, String textToSet) {
        return ComponentEditorProvider.getIntField(parent, restrictions, textToSet, null);
    }

    private static NumericField<Integer> getIntField(UiContainer parent, int restrictions, String textToSet, Object value) {
        NumericField intField = NumericField.createIntegerNumericField((UiContainer)parent, (boolean)false);
        intField.setScale(0);
        if (restrictions < 0) {
            restrictions = 180;
        }
        intField.setLength(Math.min(180, restrictions));
        intField.setRange((Number)Integer.MIN_VALUE, (Number)Integer.MAX_VALUE);
        if (value != null) {
            intField.setValue((Number)((Integer)value));
        } else {
            XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)2);
            intField.setValue((Number)(textToSet != null ? (Integer)setter.getValueFromString(textToSet) : (Integer)setter.getDefaultValue()));
        }
        intField.selectAll();
        return intField;
    }

    private static IntervalField getIntervalComponent(UiContainer parent, Object value) {
        return ComponentEditorProvider.getIntervalComponent(parent, null, value);
    }

    private static IntervalField getIntervalComponent(UiContainer parent, String textToSet) {
        return ComponentEditorProvider.getIntervalComponent(parent, textToSet, null);
    }

    private static IntervalField getIntervalComponent(UiContainer parent, String textToSet, Object value) {
        IntervalField intervalField = new IntervalField(parent);
        if (value != null) {
            intervalField.setInterval((Interval)value);
        } else {
            intervalField.setText(textToSet);
            XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)7);
            intervalField.setInterval(textToSet != null ? (Interval)setter.getValueFromString(textToSet) : (Interval)setter.getDefaultValue());
        }
        new IntervalFieldHighlighter().setComponentToHightlight((UiComponent)intervalField);
        return intervalField;
    }

    private static NumericField<Double> getRealComponent(UiContainer parent, String textToSet) {
        return ComponentEditorProvider.getRealComponent(parent, textToSet, null);
    }

    private static NumericField<Double> getRealComponent(UiContainer parent, Object value) {
        return ComponentEditorProvider.getRealComponent(parent, null, value);
    }

    private static NumericField<Double> getRealComponent(UiContainer parent, String textToSet, Object value) {
        NumericField realTextField = NumericField.createDoubleNumericField((UiContainer)parent);
        realTextField.setScale(9);
        realTextField.setLength(180);
        if (value != null) {
            realTextField.setValue((Number)((Double)value));
        } else {
            XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)4);
            realTextField.setValue((Number)(textToSet != null ? (Double)setter.getValueFromString(textToSet) : (Double)setter.getDefaultValue()));
        }
        return realTextField;
    }

    private static TextField getStringComponent(UiContainer parent, int restrictions, String textToSet) {
        TextField stringTextField = new TextField(parent);
        XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)5);
        String string = textToSet = textToSet != null ? (String)setter.getValueFromString(textToSet) : (String)setter.getDefaultValue();
        if (restrictions > 0) {
            stringTextField.setColumns(restrictions);
            if (textToSet.length() >= restrictions) {
                textToSet = textToSet.substring(0, restrictions);
            }
        }
        stringTextField.setText(textToSet);
        stringTextField.selectAll();
        return stringTextField;
    }

    private static TimeField getTimeComponent(UiContainer parent, int style, Object value) {
        return ComponentEditorProvider.getTimeComponent(parent, style, null, value);
    }

    private static TimeField getTimeComponent(UiContainer parent, int style, String textToSet) {
        return ComponentEditorProvider.getTimeComponent(parent, style, textToSet, null);
    }

    private static TimeField getTimeComponent(UiContainer parent, int style, String textToSet, Object value) {
        TimeField timeField = new TimeField(parent, ComponentEditorProvider.getStyle(style));
        if (value != null) {
            timeField.setTime((Time)value);
        } else {
            XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)6);
            timeField.setTime(textToSet != null ? (Time)setter.getValueFromString(textToSet) : (Time)setter.getDefaultValue());
        }
        return timeField;
    }
}

