/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ArrayUtils;

public class CatalogUtils {
    public static String getPrimaryKeyText(ObjectTypeDescription object) {
        String text = CatalogUtils.getPKString(object);
        if (text != null) {
            text = DesignerMsg.IS_PK.getString() + text;
        }
        return text == null ? "" : text;
    }

    public static ObjectTypeDescription getDelegatedSuperType(ObjectTypeDescription type) {
        ObjectTypeDescription delegate = null;
        for (SuperType superType : type.getSuperTypes()) {
            if (!superType.isDelegated() || superType.isHidden()) continue;
            delegate = superType.getObjectType();
        }
        return delegate;
    }

    public static List<ObjectTypeDescription> getVisibleSuperTypes(TypeDescription type) {
        ArrayList<ObjectTypeDescription> superTypes = new ArrayList<ObjectTypeDescription>();
        for (SuperType superType : type.getSuperTypes()) {
            if (superType.isHidden()) continue;
            superTypes.add(superType.getObjectType());
        }
        return superTypes;
    }

    public static CatalogObject getCatalogObject(ObjectTypeDescription objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Null object type");
        }
        if (objectType.isDefault()) {
            return CatalogObjectImpl.create(null, (TypeRef)objectType);
        }
        FuegoProject project = FuegoProject.getFrom((TypeRef)objectType);
        if (project == null) {
            throw new IllegalStateException("Could not get project from " + objectType.getText());
        }
        return project.createCatalogObject((TypeRef)objectType);
    }

    private static String getPKString(ObjectTypeDescription object) {
        String text = CatalogUtils.getSuperTypePKText(object);
        String text2 = CatalogUtils.getPkText(object);
        if (text == null) {
            text = text2;
        } else if (text2 != null) {
            text = text + "," + text2;
        }
        return text;
    }

    private static String getSuperTypePKText(ObjectTypeDescription object) {
        ObjectTypeDescription superType = CatalogUtils.getDelegatedSuperType(object);
        return superType == null ? null : CatalogUtils.getPKString(superType);
    }

    private static String getPkText(ObjectTypeDescription otd) {
        if (otd == null) {
            return null;
        }
        String text = "";
        MethodTypeDescription[] array = otd.getMembers(18, 0x1000000L, 0L);
        List<MethodTypeDescription> l = ArrayUtils.asList(array);
        if (l.size() > 0) {
            Collections.sort(l, ObjectTypeDescription.ATTRIBUTE_BY_POSITION_COMPARATOR);
            Iterator<MethodTypeDescription> it = l.iterator();
            boolean hasNext = it.hasNext();
            while (hasNext) {
                AttributeTypeDescription next = (AttributeTypeDescription)it.next();
                text = text + " " + next.getName();
                hasNext = it.hasNext();
                if (!hasNext) continue;
                text = text + ",";
            }
        }
        return text.trim().equals("") ? null : text;
    }
}

