/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.edit;

import java.util.ArrayList;
import java.util.Comparator;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.drag.SubprocessResizeCapability;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ResizeLaneCommand;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;

public class ExpandCollapseHelper {
    private FlowNodeController<Subprocess> controller;
    private Subprocess subprocess;
    private static final String ROOT = "ROOT";
    private static final String PARENT = "PARENT";
    private static final String SUBPROCESS = "SUBPROCESS";
    private static final Comparator<Point> Y_COMPARATOR = new Comparator<Point>(){

        @Override
        public int compare(Point o1, Point o2) {
            return o1.getY() - o2.getY();
        }
    };
    private static final Comparator<Point> X_COMPARATOR = new Comparator<Point>(){

        @Override
        public int compare(Point o1, Point o2) {
            return o1.getX() - o2.getX();
        }
    };

    public ExpandCollapseHelper(Subprocess subprocess, FlowNodeController<Subprocess> subcontroller) {
        this.subprocess = subprocess;
        this.controller = subcontroller;
    }

    public static void toogleExpand(Subprocess subprocess, ExpandCollapseSubcontroller subcontroller) {
        ExpandCollapseHelper helper = new ExpandCollapseHelper(subprocess, (FlowNodeController)subcontroller.getContainer());
        helper.toogleExpand();
    }

    protected int getHeightDiff() {
        return Math.max(0, this.getExpandedHeight() - this.getCollapsedHeight());
    }

    protected int getWidthDiff() {
        return Math.max(0, this.getExpandedWidth() - this.getCollapsedWidth());
    }

    private void toogleExpand() {
        IsCollapsedFeature feature = (IsCollapsedFeature)this.subprocess.getFeature(IsCollapsedFeature.class);
        if (!feature.getValue().booleanValue()) {
            this.expand();
        } else {
            this.collapse();
        }
        this.adjustParent();
    }

    private void collapse() {
        int heightDiff = this.getHeightDiff();
        int widthDiff = this.getWidthDiff();
        Point subprocessLocation = this.subprocess.getLocation();
        try {
            this.moveNodes(subprocessLocation, false, -widthDiff / 2, -heightDiff / 2);
            this.moveSequenceFlows(subprocessLocation, false, -widthDiff / 2, -heightDiff / 2);
            ResizeLaneCommand c = this.moveLane(-heightDiff);
            if (c != null) {
                c.execute();
            }
        }
        catch (CannotMoveException e) {
            // empty catch block
        }
    }

    private void expand() {
        block3: {
            int heightDiff = this.getHeightDiff();
            int widthDiff = this.getWidthDiff();
            Point subprocessLocation = this.subprocess.getLocation();
            ResizeLaneCommand resizeCommand = this.moveLane(heightDiff);
            if (resizeCommand != null) {
                resizeCommand.execute();
            }
            try {
                this.moveNodes(subprocessLocation, true, widthDiff / 2, heightDiff / 2);
                this.moveSequenceFlows(subprocessLocation, true, widthDiff / 2, heightDiff / 2);
            }
            catch (CannotMoveException e) {
                if (resizeCommand == null) break block3;
                resizeCommand.undo();
            }
        }
    }

    private void adjustParent() {
        FlowNodeController parentController = (FlowNodeController)this.getParentController(SUBPROCESS);
        if (parentController != null) {
            ExpandCollapseHelper helper = new ExpandCollapseHelper((Subprocess)parentController.getModelObject(), parentController);
            helper.adjust();
        }
    }

    private void adjust() {
        block3: {
            Rectangle preferredBounds = SubprocessResizeCapability.getMinimumRect(this.controller);
            int currentWidth = this.subprocess.getWidth();
            int currentHeight = this.subprocess.getHeight();
            int widthDiff = preferredBounds.getWidth() - currentWidth;
            int heigthDiff = preferredBounds.getHeight() - currentHeight;
            Point subprocessLocation = this.subprocess.getLocation();
            ResizeLaneCommand resizeCommand = this.moveLane(heigthDiff);
            if (resizeCommand != null) {
                resizeCommand.execute();
            }
            try {
                this.moveChildNodes(subprocessLocation, false, widthDiff / 2, heigthDiff / 2);
                this.moveSequenceFlows(subprocessLocation, false, widthDiff / 2, heigthDiff / 2);
                this.subprocess.setWidth(preferredBounds.getWidth());
                this.subprocess.setHeight(preferredBounds.getHeight());
                this.controller.getDrawableNode().refresh();
                this.adjustParent();
            }
            catch (CannotMoveException e) {
                if (resizeCommand == null) break block3;
                resizeCommand.undo();
            }
        }
    }

    private void moveSequenceFlows(Point subprocessLocation, boolean isCollapsed, int xDelta, int yDelta) {
        Point controlPoint;
        RoutingMode mode;
        SequenceFlow modelObject;
        Point translateLocation = isCollapsed ? new Point(this.getCollapsedWidth() / 2, this.getCollapsedHeight() / 2) : new Point(this.getExpandedWidth() / 2, this.getExpandedHeight() / 2);
        Point p0 = subprocessLocation.translate(translateLocation.flip());
        Point p1 = subprocessLocation.translate(translateLocation);
        ArrayList<DrawableSequenceFlow> moveX = new ArrayList<DrawableSequenceFlow>();
        ArrayList<DrawableSequenceFlow> moveY = new ArrayList<DrawableSequenceFlow>();
        this.calculateIntersectionsSequence(this.getParentController(PARENT).getDrawableObject(), p0, p1, moveX, moveY);
        for (DrawableSequenceFlow drawableSequenceFlow : moveX) {
            modelObject = (SequenceFlow)drawableSequenceFlow.getModelObject();
            mode = modelObject.getRoutingMode();
            controlPoint = modelObject.getControlPoint();
            modelObject.setRoutingData(mode, new Point(controlPoint.getX() + xDelta, controlPoint.getY()));
            drawableSequenceFlow.refresh();
        }
        for (DrawableSequenceFlow drawableSequenceFlow : moveY) {
            modelObject = (SequenceFlow)drawableSequenceFlow.getModelObject();
            mode = modelObject.getRoutingMode();
            controlPoint = modelObject.getControlPoint();
            modelObject.setRoutingData(mode, new Point(controlPoint.getX(), controlPoint.getY() + yDelta));
            drawableSequenceFlow.refresh();
        }
    }

    private void calculateIntersectionsSequence(Drawable drawableObject, Point p0, Point p1, ArrayList<DrawableSequenceFlow> moveX, ArrayList<DrawableSequenceFlow> moveY) {
        Sequence drawables = drawableObject.getDrawables();
        for (Drawable drawable : drawables) {
            this.compareSequence(X_COMPARATOR, moveX, drawable, p0, p1, moveX, moveY);
            this.compareSequence(Y_COMPARATOR, moveY, drawable, p0, p1, moveX, moveY);
        }
    }

    private void compareSequence(Comparator<Point> comparator, ArrayList<DrawableSequenceFlow> move, Drawable drawable, Point p0, Point p1, ArrayList<DrawableSequenceFlow> moveX, ArrayList<DrawableSequenceFlow> moveY) {
        Point point;
        DrawableSequenceFlow seq;
        RoutingMode mode;
        if (drawable instanceof DrawableSequenceFlow && ((mode = ((SequenceFlow)(seq = (DrawableSequenceFlow)drawable).getModelObject()).getRoutingMode()) == RoutingMode.ORTHOGONAL || mode == RoutingMode.CURVED) && (point = ((SequenceFlow)seq.getModelObject()).getControlPoint()) != null && comparator.compare(point, p0) > 0) {
            move.add((DrawableSequenceFlow)drawable);
            if (comparator.compare(point, p1) > 0) {
                move.add((DrawableSequenceFlow)drawable);
            }
        }
    }

    private ResizeLaneCommand moveLane(int heightDiff) {
        NodeContainer parentObject;
        Lane subprocessLane = this.subprocess.getLane();
        if (!(subprocessLane == null || this.subprocess.getParentObject() == null || (parentObject = this.subprocess.getParentObject()) instanceof FlowNode && ((FlowNode)parentObject).getBpmnType() == BpmnType.SUBPROCESS)) {
            return new ResizeLaneCommand(subprocessLane, subprocessLane.getSize() + heightDiff, true);
        }
        return null;
    }

    private void moveNodes(Point subprocessLocation, boolean isCollapsed, int xDelta, int yDelta) throws CannotMoveException {
        if (!this.moveChildNodes(subprocessLocation, isCollapsed, xDelta, yDelta)) {
            this.subprocess.setLocation(this.subprocess.getLocation().add(xDelta, yDelta));
            this.controller.getDrawableNode().refresh();
        }
    }

    private boolean moveChildNodes(Point subprocessLocation, boolean isCollapsed, int xDelta, int yDelta) throws CannotMoveException {
        MoveCommand c;
        FlowNode modelObject;
        boolean subprocessMoved = false;
        Lane subprocessLane = this.subprocess.getLane();
        Point translateLocation = isCollapsed ? new Point(this.getCollapsedWidth() / 2, this.getCollapsedHeight() / 2) : new Point(this.getExpandedWidth() / 2, this.getExpandedHeight() / 2);
        Point p0 = subprocessLocation.translate(translateLocation.flip());
        Point p1 = subprocessLocation.translate(translateLocation);
        ArrayList<DrawableFlowNode> nodesToMoveX = new ArrayList<DrawableFlowNode>();
        ArrayList<DrawableFlowNode> nodesToMoveY = new ArrayList<DrawableFlowNode>();
        Controller parent = this.getParentController(PARENT);
        boolean isNestedContext = parent.getModelObject() instanceof Subprocess;
        this.calculateIntersections(parent.getDrawableObject(), p0, p1, nodesToMoveX, nodesToMoveY);
        ArrayList<MoveCommand> commands = new ArrayList<MoveCommand>();
        for (DrawableFlowNode each : nodesToMoveX) {
            modelObject = each.getModelObject();
            if (!subprocessMoved && each.getModelObject() == this.subprocess) {
                subprocessMoved = true;
            }
            if (!(c = new MoveCommand(each, xDelta, 0)).isValid()) {
                throw new CannotMoveException();
            }
            commands.add(c);
        }
        for (DrawableFlowNode each : nodesToMoveY) {
            modelObject = each.getModelObject();
            if (!isNestedContext && modelObject.getLane() != subprocessLane) continue;
            c = new MoveCommand(each, 0, yDelta);
            if (!c.isValid()) {
                throw new CannotMoveException();
            }
            commands.add(c);
            if (subprocessMoved || each.getModelObject() != this.subprocess) continue;
            subprocessMoved = true;
        }
        for (MoveCommand command : commands) {
            command.execute();
        }
        return subprocessMoved;
    }

    private void calculateIntersections(Drawable drawableObject, Point p0, Point p1, ArrayList<DrawableFlowNode> moveX, ArrayList<DrawableFlowNode> moveY) {
        Sequence drawables = drawableObject.getDrawables();
        for (Drawable drawable : drawables) {
            this.compare(X_COMPARATOR, moveX, drawable, p0, p1, moveX, moveY);
            this.compare(Y_COMPARATOR, moveY, drawable, p0, p1, moveX, moveY);
        }
    }

    private void compare(Comparator<Point> comparator, ArrayList<DrawableFlowNode> move, Drawable drawable, Point p0, Point p1, ArrayList<DrawableFlowNode> moveX, ArrayList<DrawableFlowNode> moveY) {
        Point location = drawable.getLocation();
        if (comparator.compare(location, p0) > 0) {
            if (drawable instanceof DrawableFlowNode) {
                move.add((DrawableFlowNode)drawable);
                if (comparator.compare(location, p1) > 0) {
                    move.add((DrawableFlowNode)drawable);
                }
            } else {
                this.calculateIntersections(drawable, p0, p1, moveX, moveY);
            }
        }
    }

    private int getCollapsedWidth() {
        return 60;
    }

    private int getCollapsedHeight() {
        return 45;
    }

    private int getExpandedWidth() {
        return this.subprocess.getWidth();
    }

    private int getExpandedHeight() {
        return this.subprocess.getHeight();
    }

    private Controller getParentController(String searchParam) {
        Controller c = this.controller;
        while (c.getContainer() != null) {
            c = c.getContainer();
            if (PARENT.equals(searchParam) && c.getModelObject() instanceof NodeContainer) break;
            if (!SUBPROCESS.equals(searchParam) || !(c instanceof FlowNodeController) || !(c.getModelObject() instanceof Subprocess)) continue;
            return c;
        }
        return SUBPROCESS.equals(searchParam) ? null : c;
    }

    private class CannotMoveException
    extends Throwable {
        private CannotMoveException() {
        }
    }

    private static class MoveCommand
    implements Command {
        private DrawableFlowNode each;
        private int xDelta;
        private int yDelta;

        public MoveCommand(DrawableFlowNode each, int xDelta, int yDelta) {
            this.each = each;
            this.xDelta = xDelta;
            this.yDelta = yDelta;
        }

        @Override
        public String getName() {
            return "Move";
        }

        @Override
        public Object getAffectedObject() {
            return this.each.getModelObject();
        }

        @Override
        public void undo() {
            this.execute(-this.xDelta, -this.yDelta);
        }

        @Override
        public Object execute() throws ExecutionException {
            this.execute(this.xDelta, this.yDelta);
            return true;
        }

        public boolean isValid() {
            FlowNode modelObject = this.each.getModelObject();
            return modelObject.getX() + this.xDelta > 0 && modelObject.getY() + this.yDelta > 0;
        }

        private void execute(int deltax, int deltay) {
            FlowNode modelObject = this.each.getModelObject();
            modelObject.setX(modelObject.getX() + deltax);
            modelObject.setY(modelObject.getY() + deltay);
            this.each.refresh();
        }
    }
}

