/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.edit;

import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.edit.ExpandCollapseHelper;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.edit.ElementInplaceEditCapability;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class ExpandCollapseCapability
extends ElementInplaceEditCapability {
    public ExpandCollapseCapability(@NotNull ExpandCollapseSubcontroller controller) {
        super((CapableController)controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command process(@NotNull CapabilityEvent event) {
        IsCollapsedFeature feature;
        ExpandCollapseSubcontroller subcontroller = this.getController();
        Controller controller = subcontroller.getContainer();
        Controller container = controller.getContainer();
        Subprocess subprocess = (Subprocess)subcontroller.getModelObject();
        if (!this.canExecute(subprocess, (feature = (IsCollapsedFeature)subprocess.getFeature(IsCollapsedFeature.class)).isSet())) {
            return null;
        }
        controller.remove();
        Transactable transactable = (Transactable)subprocess.getProcess();
        try {
            transactable.beginTransaction();
            feature.toggleValue();
            container.refresh();
            ExpandCollapseHelper.toogleExpand(subprocess, subcontroller);
            DrawableEvent.updateBoundaries((Drawable)container.getDrawableObject(), (Activity)subprocess);
        }
        finally {
            transactable.endTransaction();
        }
        this.getDomain().getCanvas().repaint();
        return null;
    }

    @NotNull
    protected ExpandCollapseSubcontroller getController() {
        return (ExpandCollapseSubcontroller)super.getController();
    }

    private boolean canExecute(Subprocess subprocess, boolean isCollapsed) {
        if (!isCollapsed) {
            Lane lane = subprocess.getLane();
            Sequence activities = subprocess.getActivities();
            for (Activity activity : activities) {
                if (activity.getLane() == lane) continue;
                return false;
            }
        }
        return true;
    }
}

