/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.drag.ElementResizeCapability;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.subcontroller.ResizeSubcontroller;
import oracle.bpm.diagram.editor.subcontroller.Subcontroller;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ResizePositionalCommand;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class SubprocessResizeCapability
extends ElementResizeCapability {
    public SubprocessResizeCapability(@NotNull ResizeSubcontroller controller) {
        super(controller);
    }

    public static Rectangle getMinimumRect(Controller parentController) {
        Rectangle minimum = SubprocessResizeCapability.calculateMinimum(parentController);
        Point origin = parentController.getDrawableObject().getBounds().getOrigin();
        Rectangle newMin = Rectangle.deriveFromPoints(origin, minimum.getTop().translate(origin.getX() + 5, origin.getY() + 5));
        return newMin;
    }

    public static Rectangle calculateMinimum(Controller parentController) {
        Rectangle minimum = Rectangle.ZERO;
        for (Controller controller : parentController.getControllers()) {
            if (controller instanceof Subcontroller) continue;
            Rectangle bounds = controller.getDrawableObject().getBounds();
            minimum = minimum == Rectangle.ZERO ? bounds : minimum.union(bounds);
        }
        return minimum;
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        Rectangle minimum = SubprocessResizeCapability.calculateMinimum(this.getParentController());
        Point origin = this.getParentController().getDrawableObject().getBounds().getOrigin();
        this.minimum = Rectangle.deriveFromPoints(origin, minimum.getTop().translate(origin.getX() + 5, origin.getY() + 5));
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        ResizePositionalCommand result = null;
        Rectangle resize = this.getResizeBounds(event);
        if (this.getController().getModelObject() instanceof Subprocess) {
            Subprocess subprocess = (Subprocess)this.getController().getModelObject();
            result = new ResizePositionalCommand((Positional)subprocess, resize.getCenter(), resize.getWidth(), resize.getHeight());
            Controller container = this.getParentController().getContainer();
            DrawableEvent.updateBoundaries((Drawable)container.getDrawableObject(), (Activity)subprocess);
        }
        return result;
    }
}

