/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class SequenceFlowMultipleSelectionDragCapability
extends DraggableCapability {
    private Point initial = Point.ORIGIN;

    public SequenceFlowMultipleSelectionDragCapability(@NotNull SequenceFlowController controller) {
        super(CapabilityType.MOVE_NODE, (CapableController)controller);
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.initial = event.getLocation();
    }

    public void drag(@NotNull CapabilityEvent event) {
    }

    public void endDrag(@NotNull CapabilityEvent event) {
    }

    public Command process(@NotNull CapabilityEvent event) {
        ChangeSequenceFlowRoutingDataCommand result = null;
        SequenceFlow flow = (SequenceFlow)this.getController().getModelObject();
        if (flow.getRoutingMode() != RoutingMode.STRAIGHT) {
            Point delta = event.getLocation().sub(this.initial);
            result = new ChangeSequenceFlowRoutingDataCommand(flow, flow.getRoutingMode(), flow.getControlPoint().add(delta));
        }
        return result;
    }

    @NotNull
    protected SequenceFlowController getController() {
        return (SequenceFlowController)super.getController();
    }
}

