/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityModifiers;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class ProcessPanningCapability
extends DraggableCapability {
    private Point lastLocation;

    public ProcessPanningCapability(@NotNull ProcessController controller) {
        this(CapabilityType.PANNING, controller);
    }

    protected ProcessPanningCapability(@NotNull CapabilityType type, @NotNull ProcessController controller) {
        super(type, (CapableController)controller);
    }

    public boolean accept(@NotNull CapabilityModifiers modifiers) {
        return modifiers.isControlDown();
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.lastLocation = event.getLocation();
        this.getDomain().getCanvas().setCursor(Cursor.HAND_PANNING_CURSOR);
    }

    public void drag(@NotNull CapabilityEvent event) {
        Point location = event.getLocation();
        Point delta = this.lastLocation.sub(location);
        this.lastLocation = location.add(delta);
        this.getDomain().getCanvas().scrollPanningDelta(delta);
    }

    public void endDrag(@NotNull CapabilityEvent event) {
        this.lastLocation = null;
        this.getDomain().getCanvas().setCursor(Cursor.getDefaultCursor());
    }

    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    @NotNull
    protected ProcessDomain getDomain() {
        return (ProcessDomain)super.getDomain();
    }
}

