/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.diagram.editor.ControllerContainer;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityModifiers;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.NullModelObject;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class ProcessMarqueeCapability
extends DraggableCapability {
    private DrawableRectangle rectangle;

    public ProcessMarqueeCapability(@NotNull ProcessController controller) {
        this(CapabilityType.MARQUEE, controller);
    }

    protected ProcessMarqueeCapability(@NotNull CapabilityType type, @NotNull ProcessController controller) {
        super(type, (CapableController)controller);
    }

    public boolean accept(@NotNull CapabilityModifiers modifiers) {
        return !modifiers.isControlDown();
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.getDrawableRectangle().add();
        Point offset = this.getController().getDrawableObject().getAbsoluteOffset();
        this.getDrawableRectangle().initialize(event.getLocation().translate(offset.flip()));
    }

    public void drag(@NotNull CapabilityEvent event) {
        Point offset = this.getController().getDrawableObject().getAbsoluteOffset();
        this.updateSelection(event.getLocation().translate(offset.flip()));
    }

    public void endDrag(@NotNull CapabilityEvent event) {
        this.getDrawableRectangle().remove();
    }

    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    @NotNull
    protected ProcessController getController() {
        return (ProcessController)super.getController();
    }

    private void updateSelection(@NotNull Point location) {
        this.getDrawableRectangle().update(location);
        List<FlowElementController> copy = this.getControllersInsideRectangle();
        Selection selection = copy.isEmpty() ? DefaultSelection.EMPTY : DefaultSelection.createMultiple(copy);
        this.getDomain().getSelectionProvider().setSelection(selection);
    }

    private List<FlowElementController> getControllersInsideRectangle() {
        return ControllerUtils.getControllersAt((ControllerContainer)this.getController(), this.getDrawableRectangle().getBounds());
    }

    private DrawableRectangle getDrawableRectangle() {
        if (this.rectangle == null) {
            this.rectangle = new DrawableRectangle((Drawable)this.getController().getDrawableObject());
        }
        return this.rectangle;
    }

    private static class DrawableRectangle
    extends DrawableFeedback<NullModelObject>
    implements Renderer {
        private Point origin;
        private Rectangle rectangle;

        private DrawableRectangle(@NotNull Drawable container) {
            super(container, NullModelObject.getInstance(), DesignerLayer.SELECTION);
            this.attachRenderer(this);
        }

        private void initialize(@NotNull Point location) {
            this.origin = location;
            this.rectangle = Rectangle.createAround(this.origin, 0);
            this.refresh();
        }

        private void update(@NotNull Point location) {
            this.rectangle = Rectangle.deriveFromPoints(this.origin, location);
            this.refresh();
        }

        public void refresh() {
            this.setLocation(this.rectangle.getCenter());
            this.setWidth(this.rectangle.getWidth());
            this.setHeight(this.rectangle.getHeight());
        }

        public void render() {
            DrawContext context = this.getContext();
            Rectangle bounds = this.getBounds().scaled(context.getScale());
            Graphics graphics = context.getGraphics();
            Stroke stroke = graphics.getStroke();
            Color color = graphics.getForeground();
            graphics.setForeground(Color.TRANSLUCENT_35);
            graphics.fillRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            graphics.setStroke(Stroke.ONE_SOLID);
            graphics.setForeground(Color.FUEGO_BLUE);
            graphics.drawRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            graphics.setForeground(color);
            graphics.setStroke(stroke);
        }
    }
}

