/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.drag.ElementResizeCapability;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.subcontroller.ResizeSubcontroller;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.command.design.ResizePositionalCommand;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.TextAnnotation;
import org.jetbrains.annotations.NotNull;

public class NoteResizeCapability
extends ElementResizeCapability {
    public NoteResizeCapability(@NotNull ResizeSubcontroller controller) {
        super(controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        Point origin = this.getParentController().getDrawableObject().getBounds().getOrigin();
        this.minimum = Rectangle.valueOf(origin, TextAnnotationImpl.MINIMUM_SIZE);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        ResizePositionalCommand result = null;
        Rectangle bounds = this.getResizeBounds(event);
        if (this.getController().getModelObject() instanceof TextAnnotation) {
            TextAnnotation note = (TextAnnotation)this.getController().getModelObject();
            result = new ResizePositionalCommand((Positional)note, bounds.getCenter(), bounds.getWidth(), bounds.getHeight());
        }
        return result;
    }
}

