/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.designer.capability.ConnectionVisuals;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.command.EnsureLaneCommand;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.Grid;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.ImageDraggableCapability;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.command.design.MoveFlowNodeCommand;
import oracle.bpm.project.command.design.RelocateActivityCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class NodeMoveCapability
extends ImageDraggableCapability {
    private ConnectionVisuals updater = new ConnectionVisuals(false);

    public NodeMoveCapability(@NotNull FlowNodeController controller) {
        this(CapabilityType.MOVE_NODE, controller);
    }

    protected NodeMoveCapability(@NotNull CapabilityType type, @NotNull FlowNodeController controller) {
        super(type, (CapableController)controller);
    }

    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.cancelAnyVisuals(event);
    }

    protected void drag(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        super.drag(feedback, location, event);
    }

    protected void drop(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        this.updater.resetCurrentTarget();
        super.drop(feedback, location, event);
    }

    @NotNull
    protected DrawableFeedback createFeedbackImage() {
        DrawableFlowElement drawableFlowElement = this.getFlowNodeController().getDrawableObject();
        return ImageFeedback.create(drawableFlowElement);
    }

    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        AddLaneAction.LaneInfo lane = null;
        boolean needs = EnsureLaneCommand.needsNewLane(destination, this.getModelObject());
        if (needs) {
            lane = AddLaneAction.newLaneName(this.getModelObject().getProcess(), false);
        }
        Point location = this.updateDestination(destination);
        SequenceFlowController target = event.getTarget() instanceof SequenceFlowController ? (SequenceFlowController)event.getTarget() : null;
        Grid grid = this.getDomain().getGrid();
        MultipleCommand result = new MultipleCommand(new ProjectObject[]{this.getModelObject()});
        if (!needs || lane != null) {
            result.addCommand((Command)((Object)new EnsureLaneCommand(destination, this.getModelObject(), lane)));
            if (target != null && this.canBeInsertedIntoTransition(event, target)) {
                if (this.shouldRelocate(event)) {
                    result.addCommand((Command)new RelocateActivityCommand(this.getModelObject(), location, (SequenceFlow)target.getModelObject(), ((Integer)grid.getSize().get()).intValue()));
                    if (DesignerPreferences.getPreferences().isAutoLayout()) {
                        result.addCommand((Command)new LayoutModelCommand(this.getModelObject().getProcess(), DesignerPreferences.getPreferences().isOptimizeLanesOnAutoLayout()));
                    }
                } else {
                    result.addCommand((Command)new MoveFlowNodeCommand(this.getModelObject(), location, ((Integer)grid.getSize().get()).intValue(), (SequenceFlow)target.getModelObject()));
                }
            } else {
                result.addCommand((Command)new MoveFlowNodeCommand(this.getModelObject(), location, ((Integer)grid.getSize().get()).intValue()));
            }
        }
        return result;
    }

    private boolean shouldRelocate(CapabilityEvent event) {
        boolean isShiftDown = event.getEvent().isShiftDown();
        return this.isDefaultInsertInTranstion() ? !isShiftDown : isShiftDown;
    }

    private boolean isDefaultInsertInTranstion() {
        return false;
    }

    private Point updateTargetAndDestination(@NotNull Point destination, @NotNull CapabilityEvent event) {
        Controller controller = event.getTarget();
        Point location = this.updateDestination(destination);
        boolean isRelocate = this.shouldRelocate(event);
        if (!(controller instanceof SequenceFlowController) && ModelUtils.canBeInsertedInATransition(this.getFlowNodeController().getModelObject(), (boolean)isRelocate)) {
            NodeContainerController container = this.getFlowNodeController().getContainer();
            SequenceFlowController closest = ControllerUtils.getClosestTransition(this.getFlowNodeController(), container, location, event.getEvent().isShiftDown(), false, isRelocate);
            event.setTarget((Controller)closest);
        }
        this.updater.updateWithTarget(event, (FlowNode)this.getFlowNodeController().getModelObject(), isRelocate);
        return location;
    }

    private Point updateDestination(@NotNull Point destination) {
        Point result = destination;
        Drawable drawable = this.getController().getDrawableObject();
        if (!this.getModelObject().getParentObject().equals(this.getModelObject().getProcess())) {
            Rectangle bounds = Rectangle.createAround(destination, drawable.getWidth(), drawable.getHeight()).expand(3);
            Drawable parent = drawable.getContainer();
            Rectangle container = Rectangle.valueOf(Point.ORIGIN, parent.getWidth(), parent.getHeight());
            if (!container.contains(bounds)) {
                Point originDelta = container.getOrigin().sub(bounds.getOrigin());
                result = result.translate(Math.max(0, originDelta.getX()), Math.max(0, originDelta.getY()));
                Point topDelta = container.getTop().sub(bounds.getTop());
                result = result.translate(Math.min(0, topDelta.getX()), Math.min(0, topDelta.getY()));
            }
        }
        return result;
    }

    private boolean canBeInsertedIntoTransition(CapabilityEvent event, SequenceFlowController target) {
        return ModelUtils.canBeInsertedInTransition(this.getFlowNodeController().getModelObject(), (SequenceFlow)((SequenceFlow)target.getModelObject()), (boolean)this.shouldRelocate(event));
    }

    private FlowNode getModelObject() {
        return this.getFlowNodeController().getModelObject();
    }

    private FlowNodeController getFlowNodeController() {
        return (FlowNodeController)this.getController();
    }
}

