/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.ConnectionVisuals;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.MeasurementController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.ImageDraggableCapability;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.ChangeMeasurementTargetCommand;
import oracle.bpm.project.command.design.MoveObjectCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class MeasurementMoveCapability
extends ImageDraggableCapability {
    private ConnectionVisuals updater = this.createConnectionVisuals();

    public MeasurementMoveCapability(@NotNull MeasurementController controller) {
        this(CapabilityType.MOVE_MEASUREMENT, controller);
    }

    protected MeasurementMoveCapability(@NotNull CapabilityType type, @NotNull MeasurementController controller) {
        super(type, (CapableController)controller);
    }

    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.cancelAnyVisuals(event);
    }

    protected void drag(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        super.drag(feedback, location, event);
    }

    protected ConnectionVisuals createConnectionVisuals() {
        return new ConnectionVisuals(false);
    }

    @NotNull
    protected DrawableFeedback createFeedbackImage() {
        DrawableFlowElement drawable = this.getController().getDrawableObject();
        return ImageFeedback.create(drawable);
    }

    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateTargetAndDestination(destination, event);
        SequenceFlow target = event.getTarget() instanceof SequenceFlowController ? (SequenceFlow)((SequenceFlowController)event.getTarget()).getModelObject() : null;
        Measurement measurement = this.getMeasurement();
        MultipleCommand result = new MultipleCommand(new ProjectObject[]{measurement});
        if (target != null && !target.equals(measurement.getTransition())) {
            result.addCommand((Command)new ChangeMeasurementTargetCommand(measurement, target));
        }
        result.addCommand((Command)new MoveObjectCommand((Positional)measurement, location, ((Integer)this.getDomain().getGrid().getSize().get()).intValue()));
        this.updater.resetCurrentTarget();
        return result;
    }

    @NotNull
    protected MeasurementController getController() {
        return (MeasurementController)super.getController();
    }

    private Point updateTargetAndDestination(@NotNull Point destination, @NotNull CapabilityEvent event) {
        Point location = this.updateDestination(destination);
        Controller target = event.getTarget();
        if (!(target instanceof SequenceFlowController)) {
            SequenceFlowController closest = ControllerUtils.getClosestTransition(this.getController().getContainer(), location, event.getEvent().isShiftDown(), false);
            event.setTarget((Controller)closest);
        }
        this.updater.updateWithTarget(event);
        return location;
    }

    private Point updateDestination(@NotNull Point destination) {
        Point result = destination;
        DrawableFlowElement drawable = this.getController().getDrawableObject();
        if (!this.getMeasurement().getParentObject().equals(this.getMeasurement().getProcess())) {
            Rectangle bounds = Rectangle.createAround(destination, drawable.getWidth(), drawable.getHeight()).expand(3);
            Drawable parent = drawable.getContainer();
            Rectangle container = Rectangle.valueOf(Point.ORIGIN, parent.getWidth(), parent.getHeight());
            if (!container.contains(bounds)) {
                Point originDelta = container.getOrigin().sub(bounds.getOrigin());
                result = result.translate(Math.max(0, originDelta.getX()), Math.max(0, originDelta.getY()));
                Point topDelta = container.getTop().sub(bounds.getTop());
                result = result.translate(Math.min(0, topDelta.getX()), Math.min(0, topDelta.getY()));
            }
        }
        return result;
    }

    private Measurement getMeasurement() {
        return (Measurement)this.getController().getModelObject();
    }
}

