/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.controller.LaneColumnController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.ImageDraggableCapability;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ResizeLaneCommand;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import org.jetbrains.annotations.NotNull;

public class LaneResizeCapability
extends ImageDraggableCapability {
    private DragMinimumSizeController sizeController = new DragMinimumSizeController();
    private static final Color RED_TRANSLUCENT = Color.valueOf((int)200, (int)20, (int)20, (int)150);
    private static final Color WHITE_TRANSLUCENT = Color.valueOf((Color)Color.WHITE, (int)180);

    public LaneResizeCapability(@NotNull LaneColumnController controller) {
        this(CapabilityType.RESIZE, controller);
    }

    protected LaneResizeCapability(@NotNull CapabilityType type, @NotNull LaneColumnController controller) {
        super(type, (CapableController)controller);
    }

    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.eraseSourceVisuals(event);
    }

    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return Point.ORIGIN;
    }

    protected void startDrag(@NotNull Drawable feedback, @NotNull CapabilityEvent event) {
        this.sizeController.setMinimumSize((Lane)this.getController().getModelObject());
        super.startDrag(feedback, event);
    }

    protected void drag(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        DrawContext context = this.getDrawContext();
        int offsetPlusSize = context.isHorizontalDrawing() ? destination.getY() : destination.getX();
        boolean valid = this.sizeController.checkValidNewOffsetPlusSize(offsetPlusSize);
        ((DrawableLaneColumnFeedback)feedback).setForeground(valid ? LaneResizeCapability.WHITE_TRANSLUCENT : LaneResizeCapability.RED_TRANSLUCENT);
        super.drag(feedback, destination, event);
    }

    @NotNull
    protected DrawableFeedback createFeedbackImage() {
        return new DrawableLaneColumnFeedback(this.getController());
    }

    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        DrawContext context = this.getDrawContext();
        int offsetPlusSize = context.isHorizontalDrawing() ? destination.getY() : destination.getX();
        ResizeLaneCommand result = null;
        if (this.sizeController.checkValidNewOffsetPlusSize(offsetPlusSize)) {
            Lane lane = (Lane)this.getController().getModelObject();
            result = new ResizeLaneCommand(lane, offsetPlusSize - lane.getOffset());
        }
        this.sizeController.resetMinimumSize();
        return result;
    }

    @NotNull
    protected LaneColumnController getController() {
        return (LaneColumnController)super.getController();
    }

    private DrawContext getDrawContext() {
        return this.getController().getDrawableObject().getContext();
    }

    private static class DrawableLaneColumnFeedback
    extends DrawableFeedback<Lane> {
        private final LaneColumnController controller;
        private Color foreground;

        private DrawableLaneColumnFeedback(@NotNull LaneColumnController controller) {
            super(controller.getDrawableObject().getContainer(), (FlowElement)controller.getModelObject(), DesignerLayer.CAPABILITY);
            this.controller = controller;
        }

        public int getWidth() {
            DrawContext context = this.getContext();
            return context.isHorizontalDrawing() ? 20000 : this.getSizeForLocation(context);
        }

        public int getHeight() {
            DrawContext context = this.getContext();
            return context.isHorizontalDrawing() ? this.getSizeForLocation(context) : 20000;
        }

        @NotNull
        public Point getLocation() {
            DrawContext context = this.controller.getDomain().getContext();
            int modelOffsetPlusSize = ((Lane)this.getModelObject()).getOffset() + ((Lane)this.getModelObject()).getSize();
            Point pointerLocation = super.getLocation();
            int y = context.isHorizontalDrawing() ? Math.min(modelOffsetPlusSize, pointerLocation.getY()) : 0;
            int x = context.isHorizontalDrawing() ? 0 : Math.min(modelOffsetPlusSize, pointerLocation.getX());
            return new Point(x + this.getWidth() / 2, y + this.getHeight() / 2);
        }

        public void draw() {
            DrawContext context = this.getContext();
            Graphics graphics = context.getGraphics();
            graphics.setForeground(this.foreground);
            Rectangle bounds = context.scale(this.getBounds());
            graphics.fill(bounds);
            graphics.setForeground(Color.GRAY);
            graphics.setStroke(Stroke.TWO_SOLID);
            graphics.drawLine(bounds.getX(), bounds.getY(), bounds.getX() + bounds.getWidth(), bounds.getY());
            graphics.drawLine(bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        }

        private int getSizeForLocation(@NotNull DrawContext context) {
            int modelOffsetPlusSize = ((Lane)this.getModelObject()).getOffset() + ((Lane)this.getModelObject()).getSize();
            int pointerOffsetPlusSize = context.isHorizontalDrawing() ? super.getLocation().getY() : super.getLocation().getX();
            return Math.abs(pointerOffsetPlusSize - modelOffsetPlusSize);
        }

        private void setForeground(@NotNull Color foreground) {
            this.foreground = foreground;
        }
    }

    private static class DragMinimumSizeController {
        private Lane lane;
        private int minimumValue = 200;

        private DragMinimumSizeController() {
        }

        private void setMinimumSize(@NotNull Lane lane) {
            this.minimumValue = LaneUtils.calculateMinimunLaneSize((Lane)lane, (int)100);
            this.lane = lane;
        }

        private void resetMinimumSize() {
            this.minimumValue = 200;
            this.lane = null;
        }

        private boolean checkValidNewOffsetPlusSize(int newOffsetPlusSize) {
            return this.minimumValue < newOffsetPlusSize - this.lane.getOffset();
        }
    }
}

