/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.controller.LaneController;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.ImageDraggableCapability;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.MoveLaneCommand;
import oracle.bpm.project.model.processes.Lane;
import org.jetbrains.annotations.NotNull;

public class LaneMoveCapability
extends ImageDraggableCapability {
    public LaneMoveCapability(@NotNull LaneController controller) {
        this(CapabilityType.MOVE_LANE, controller);
    }

    protected LaneMoveCapability(@NotNull CapabilityType type, @NotNull LaneController controller) {
        super(type, (CapableController)controller);
    }

    @NotNull
    protected DrawableFeedback<?> createFeedbackImage() {
        return ImageFeedback.create(this.getController().getDrawableObject());
    }

    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        DrawableLaneName drawable = this.getController().getDrawableObject();
        DrawContext context = drawable.getContext();
        Point result = super.setDistanceToPointer(event);
        result = result.add(drawable.getWidth() / 2, drawable.getHeight() / 2 + ((Lane)this.getController().getModelObject()).getOffset());
        int offset = context.scale(drawable.getContainer().getAbsoluteOffset().getX());
        int deltaX = Math.max(0, context.getDeltaX() - offset);
        result = result.translate(context.unscale(deltaX), 0);
        return result;
    }

    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        return new MoveLaneCommand((Lane)this.getController().getModelObject(), destination);
    }

    @NotNull
    protected LaneController getController() {
        return (LaneController)super.getController();
    }
}

