/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.controller.LaneColumnController;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.ResizeLaneCommand;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import org.jetbrains.annotations.NotNull;

public class LaneColumnResizeCapability
extends DraggableCapability {
    private final DragMinimumSizeController sizer = new DragMinimumSizeController();
    private static final Color RED_TRANSLUCENT = Color.valueOf((int)200, (int)20, (int)20, (int)150);
    private static final Color WHITE_TRANSLUCENT = Color.valueOf((Color)Color.WHITE, (int)180);

    public LaneColumnResizeCapability(LaneColumnController controller) {
        super(CapabilityType.RESIZE, (CapableController)controller);
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.sizer.setMinimumSize(this.getLane());
    }

    public void drag(@NotNull CapabilityEvent event) {
        DrawableLaneColumn column = this.getController().getDrawableObject();
        int top = this.getLaneColumnTop(event.getLocation());
        boolean valid = this.sizer.checkValidSize(top - ((Lane)this.getController().getModelObject()).getOffset());
        column.setBackground(valid ? WHITE_TRANSLUCENT : RED_TRANSLUCENT);
        top = valid ? top : ((Lane)this.getController().getModelObject()).getOffset() + this.sizer.getMinimumValue();
        column.setLocation(new Point(column.getWidth() / 2, top));
        this.getDomain().getCanvas().repaint();
    }

    public void endDrag(@NotNull CapabilityEvent event) {
        this.getController().getDrawableObject().refresh();
        this.sizer.resetMinimumSize();
    }

    public Command process(@NotNull CapabilityEvent event) {
        Lane lane;
        ResizeLaneCommand result = null;
        int top = this.getLaneColumnTop(event.getLocation());
        if (this.sizer.checkValidSize(top - (lane = (Lane)this.getController().getModelObject()).getOffset())) {
            result = new ResizeLaneCommand(lane, top - lane.getOffset());
        }
        this.sizer.resetMinimumSize();
        return result;
    }

    private int getLaneColumnTop(@NotNull Point location) {
        DrawableLaneColumn column = this.getController().getDrawableObject();
        Point offset = column.getContainer().getAbsoluteOffset();
        return location.sub(offset).getY();
    }

    @NotNull
    protected LaneColumnController getController() {
        return (LaneColumnController)super.getController();
    }

    private Lane getLane() {
        return (Lane)this.getController().getModelObject();
    }

    private static class DragMinimumSizeController {
        private int minimumValue = 200;

        private DragMinimumSizeController() {
        }

        private void setMinimumSize(@NotNull Lane lane) {
            this.minimumValue = LaneUtils.calculateMinimunLaneSize((Lane)lane, (int)100);
        }

        private void resetMinimumSize() {
            this.minimumValue = 200;
        }

        private int getMinimumValue() {
            return this.minimumValue;
        }

        private boolean checkValidSize(int newOffsetPlusSize) {
            return this.minimumValue < newOffsetPlusSize;
        }
    }
}

