/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.diagram.editor.subcontroller.ResizeSubcontroller;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ElementResizeCapability
extends DraggableCapability {
    protected Rectangle minimum = Rectangle.ZERO;

    protected ElementResizeCapability(@NotNull ResizeSubcontroller controller) {
        this(CapabilityType.RESIZE, controller);
    }

    protected ElementResizeCapability(@NotNull CapabilityType type, @NotNull ResizeSubcontroller controller) {
        super(type, (CapableController)controller);
    }

    public void startDrag(@NotNull CapabilityEvent event) {
    }

    public void drag(@NotNull CapabilityEvent event) {
        Rectangle bounds = this.getResizeBounds(event);
        Drawable drawable = this.getParentController().getDrawableObject();
        drawable.setLocation(bounds.getCenter());
        drawable.setWidth(bounds.getWidth());
        drawable.setHeight(bounds.getHeight());
        this.getDomain().getCanvas().repaint();
    }

    public void endDrag(@NotNull CapabilityEvent event) {
    }

    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    protected Rectangle getResizeBounds(@NotNull CapabilityEvent event) {
        Point relative = event.getLocation().sub(this.getParentController().getDrawableObject().getContainer().getAbsoluteOffset());
        Point top = this.minimum.getTop().max(relative);
        return Rectangle.deriveFromPoints(this.minimum.getOrigin(), top);
    }

    protected Controller getParentController() {
        return this.getController().getContainer();
    }
}

