/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableConnection;
import oracle.bpm.diagram.draw.DrawableConnectionImpl;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.diagram.editor.ConnectionController;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.diagram.editor.subcontroller.AnchorSubcontroller;
import oracle.bpm.geom.Elbow;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.QuadCurve;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.command.design.ChangeTransitionSourceCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.policies.SequenceFlowPolicies;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class AnchorMoveCapability
extends DraggableCapability {
    private ConnectionFeedback connection;

    public AnchorMoveCapability(@NotNull AnchorSubcontroller controller, @NotNull CapabilityType type) {
        super(type, (CapableController)controller);
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.getDomain().getSelectionProvider().setSelection((Controller)this.getConnectionController());
        this.connection = this.createConnectionFeedback();
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        this.connection.update(event, this.getController().getAnchor());
        this.connection.add();
    }

    public void drag(@NotNull CapabilityEvent event) {
        Rectangle prev = this.connection.getBounds();
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        this.connection.update(event, this.getController().getAnchor());
        Rectangle post = this.connection.getBounds();
        Rectangle union = prev.union(post).expand(10).translate(this.getConnectionContainer().getDrawableObject().getAbsoluteOffset());
        this.getDomain().getCanvas().paintImmediately(this.getDomain().getContext().scale(union));
    }

    public void endDrag(@NotNull CapabilityEvent event) {
        this.connection.remove();
    }

    public Command process(@NotNull CapabilityEvent event) {
        ChangeTransitionSourceCommand result = null;
        SequenceFlow flow = (SequenceFlow)this.getConnectionController().getModelObject();
        switch (this.getController().getAnchor()) {
            case FROM: {
                Drawable source = this.connection.getDrawableSource();
                if (source == null) break;
                result = new ChangeTransitionSourceCommand(flow, (FlowNode)source.getModelObject());
                break;
            }
            case TO: {
                Drawable target = this.connection.getDrawableTarget();
                if (target == null) break;
                result = new ChangeTransitionTargetCommand(flow, (FlowNode)target.getModelObject());
                break;
            }
            default: {
                Point ctrl = event.getLocation().sub(this.getConnectionContainer().getDrawableObject().getAbsoluteOffset());
                RoutingMode mode = this.connection.getRoutingMode();
                if (mode == RoutingMode.CURVED) {
                    ctrl = QuadCurve.calculateControlPoint(flow.getSource().getLocation(), ctrl, flow.getTarget().getLocation());
                }
                result = new ChangeSequenceFlowRoutingDataCommand(flow, mode, ctrl);
            }
        }
        return result;
    }

    public void eraseTargetVisuals(@NotNull CapabilityEvent event) {
        this.getController().getDomain().getCanvas().setCursor(Cursor.DEFAULT_CURSOR);
        super.eraseTargetVisuals(event);
    }

    @NotNull
    protected AnchorSubcontroller getController() {
        return (AnchorSubcontroller)super.getController();
    }

    private static FlowNodeController getValidTarget(@NotNull CapabilityEvent event, @NotNull ConnectionController sequenceController, @NotNull DrawableUtils.TransitionAnchor anchor) {
        FlowNodeController targetController;
        FlowNodeController sourceController;
        HighlightSubcontroller highlight;
        FlowNodeController underMouseController;
        FlowNodeController flowNodeController = underMouseController = event.getTarget() instanceof FlowNodeController ? (FlowNodeController)event.getTarget() : null;
        if (underMouseController == null && event.getTarget() instanceof HighlightSubcontroller && (highlight = (HighlightSubcontroller)event.getTarget()).getContainer() instanceof FlowNodeController) {
            underMouseController = (FlowNodeController)highlight.getContainer();
        }
        if (anchor == DrawableUtils.TransitionAnchor.FROM) {
            sourceController = underMouseController;
            targetController = (FlowNodeController)sequenceController.getTargetController();
        } else {
            sourceController = (FlowNodeController)sequenceController.getSourceController();
            targetController = underMouseController;
        }
        if (targetController != null && sourceController != null) {
            try {
                SequenceFlowPolicies.checkSequenceFlow(sourceController.getModelObject(), targetController.getModelObject(), (boolean)((SequenceFlow)((SequenceFlowController)sequenceController).getModelObject()).isConditionalFlow(), (boolean)false);
            }
            catch (ProjectException e) {
                targetController = null;
            }
        } else if (targetController != null && !ModelUtils.shouldHaveOutgoingSequenceFlow(targetController.getModelObject())) {
            targetController = null;
        }
        return anchor == DrawableUtils.TransitionAnchor.FROM ? sourceController : targetController;
    }

    private ConnectionController getConnectionController() {
        return this.getController().getContainer();
    }

    private DrawableConnection getDrawableConnection() {
        return this.getConnectionController().getDrawableObject();
    }

    private ConnectionFeedback createConnectionFeedback() {
        Point ctrl;
        Drawable target;
        ConnectionFeedback result = new ConnectionFeedback(this.getConnectionContainer(), this.getConnectionController());
        Drawable source = this.getDrawableConnection().getDrawableSource();
        if (source != null) {
            result.setDrawableSource(source);
        }
        if ((target = this.getDrawableConnection().getDrawableTarget()) != null) {
            result.setDrawableTarget(target);
        }
        if (!(ctrl = this.getDrawableConnection().getControlPoint()).equals(DrawableUtils.NULL_CONTROL_POINT)) {
            result.setControlPointLocation(ctrl);
        }
        return result;
    }

    private Controller getConnectionContainer() {
        return this.getConnectionController().getContainer();
    }

    public static class ConnectionFeedback
    extends DrawableConnectionImpl<Object> {
        private final ConnectionController connectionController;
        private RoutingMode mode;

        public ConnectionFeedback(@NotNull Controller container, @NotNull ConnectionController connectionController) {
            super(container.getDrawableObject(), connectionController.getModelObject(), DesignerLayer.CAPABILITY);
            this.connectionController = connectionController;
            this.mode = ((SequenceFlow)connectionController.getModelObject()).getRoutingMode();
        }

        public void update(@NotNull CapabilityEvent event, @NotNull DrawableUtils.TransitionAnchor anchor) {
            FlowNodeController controller = AnchorMoveCapability.getValidTarget(event, this.connectionController, anchor);
            Point location = event.getLocation().sub(this.getContainer().getAbsoluteOffset());
            switch (anchor) {
                case FROM: {
                    if (controller != null) {
                        this.setDrawableSource(controller.getDrawableObject());
                        controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                        break;
                    }
                    this.setSourceLocation(location);
                    break;
                }
                case TO: {
                    if (controller != null) {
                        this.setDrawableTarget(controller.getDrawableObject());
                        controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                        break;
                    }
                    this.setTargetLocation(location);
                    break;
                }
                default: {
                    this.connectionController.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                    Point ctrl = location;
                    if (this.mode == RoutingMode.CURVED) {
                        ctrl = QuadCurve.calculateControlPoint(this.source.getRawLocation(), ctrl, this.target.getRawLocation());
                    }
                    if (this.mode == RoutingMode.STRAIGHT) {
                        this.mode = RoutingMode.ORTHOGONAL;
                    }
                    this.setControlPointLocation(ctrl);
                }
            }
        }

        public RoutingMode getRoutingMode() {
            return this.mode;
        }

        protected Path createRawPath(@NotNull Point begin, @NotNull Point end) {
            return this.mode == RoutingMode.STRAIGHT || this.control.isNull() ? new Line(begin, end) : (this.mode == RoutingMode.ORTHOGONAL ? new Elbow(begin, this.control.getRawLocation(), end) : new QuadCurve(begin, this.control.getRawLocation(), end));
        }
    }
}

