/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.drag.ElementResizeCapability;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.subcontroller.ResizeSubcontroller;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.ResizePositionalCommand;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Positional;
import org.jetbrains.annotations.NotNull;

public class ActivityResizeCapability
extends ElementResizeCapability {
    public ActivityResizeCapability(@NotNull ResizeSubcontroller controller) {
        super(controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        Point origin = this.getParentController().getDrawableObject().getBounds().getOrigin();
        this.minimum = Rectangle.deriveFromPoints(origin, this.minimum.getTop().translate(5, 5));
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        ResizePositionalCommand result = null;
        Rectangle bounds = this.getResizeBounds(event);
        if (this.getController().getModelObject() instanceof Activity) {
            Activity node = (Activity)this.getController().getModelObject();
            result = new ResizePositionalCommand((Positional)node, bounds.getCenter(), bounds.getWidth(), bounds.getHeight());
            Controller container = this.getParentController().getContainer();
            DrawableEvent.updateBoundaries((Drawable)container.getDrawableObject(), (Activity)node);
        }
        return result;
    }
}

