/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.add.ImageAddingCapability;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddNoteCommand;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class ProcessAddNoteCapability
extends ImageAddingCapability {
    public ProcessAddNoteCapability(@NotNull ProcessController container) {
        super(CapabilityType.ADD_NOTE, (CapableController)container);
    }

    @NotNull
    protected DrawableFeedback createFeedbackImage(CapabilityEvent event) {
        return ImageFeedback.create(this.getNoteController(event).getDrawableObject(), this.getContext());
    }

    protected void startAdd(@NotNull Drawable feedback, @NotNull CapabilityEvent event) {
        this.getDomain().getCanvas().setCursor(Cursor.TEXT_CURSOR);
        super.startAdd(feedback, event);
    }

    protected void endAdd(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.getDomain().getCanvas().setCursor(Cursor.DEFAULT_CURSOR);
        super.endAdd(feedback, destination, event);
    }

    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        return new AddNoteCommand((TextAnnotation)this.getNoteController(event).getModelObject(), destination.getX(), destination.getY());
    }

    private NoteController getNoteController(@NotNull CapabilityEvent event) {
        return (NoteController)event.getAdding();
    }
}

