/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.provider.SequenceFlowActions;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.processdesigner.states.AddingSequenceFlowState;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.add.AddingCapability;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.process.policies.SequenceFlowPolicies;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class ContainerAddingSequenceFlowCapability
extends AddingCapability {
    public ContainerAddingSequenceFlowCapability(@NotNull NodeContainerController container) {
        super(CapabilityType.ADD_CONNECTION, (CapableController)container);
    }

    public void startAdd(@NotNull CapabilityEvent event) {
        this.updateConnectionFeedback(event);
        this.getDrawableConnectionFeedback(event).add();
        this.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
    }

    public void updateSource(@NotNull CapabilityEvent event) {
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        this.update(event, DrawableHelper.TransitionAnchor.FROM);
    }

    public void updateAdd(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
        Drawable source = connection.getDrawableSource();
        this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
        if (source != null) {
            DiagramContext context = this.getDomain().getContext();
            Rectangle prev = connection.getBounds();
            this.updateConnectionFeedback(event);
            Rectangle post = connection.getBounds();
            Rectangle union = prev.union(post).expand(10).translate(source.getContainer().getAbsoluteOffset());
            this.getDomain().getCanvas().paintImmediately(context.scale(union));
        } else if (this.getValidTarget(event, DrawableHelper.TransitionAnchor.FROM) != null) {
            this.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
        }
    }

    public void endAdd(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
        Rectangle bounds = connection.getBounds();
        connection.remove();
        Rectangle repaint = this.getDomain().getContext().scale(bounds.expand(10).translate(this.getController().getDrawableObject().getAbsoluteOffset()));
        this.getDomain().getCanvas().paintImmediately(repaint);
    }

    public Command process(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
        Drawable drawableSource = connection.getDrawableSource();
        Drawable drawableTarget = connection.getDrawableTarget();
        if (drawableSource != null && drawableTarget != null) {
            FlowNode source = (FlowNode)drawableSource.getModelObject();
            FlowNode target = (FlowNode)drawableTarget.getModelObject();
            Object container = this.getController().getModelObject();
            if (container.equals(target)) {
                container = target.getParentObject();
            }
            if (container.equals(source)) {
                container = source.getParentObject();
            }
            SequenceFlow flow = container.createSequenceFlow(source, target);
            if (((SequenceFlow)connection.getModelObject()).isConditionalFlow()) {
                flow.toConditionalFlow();
            }
            AddTransitionCommand addTransition = new AddTransitionCommand(flow);
            ProjectCommand layoutTransition = SequenceFlowActions.getSequenceFlowRoutingModeCommand(flow, DesignerPreferences.getPreferences().getTransitionDefaultRoutingMode());
            MultipleCommand result = new MultipleCommand(new ProjectObject[]{flow});
            result.addCommand((Command)addTransition);
            result.addCommand((Command)layoutTransition);
            return result;
        }
        return null;
    }

    public void eraseTargetVisuals(@NotNull CapabilityEvent event) {
        this.getController().getDomain().getCanvas().setCursor(Cursor.DEFAULT_CURSOR);
        this.getDrawableConnectionFeedback(event).remove();
        super.eraseTargetVisuals(event);
    }

    public void update(@NotNull CapabilityEvent event, @NotNull DrawableHelper.TransitionAnchor anchor) {
        FlowNodeController controller = this.getValidTarget(event, anchor);
        AddingSequenceFlowState.DrawableConnectionFeedback feedback = this.getDrawableConnectionFeedback(event);
        Drawable drawableSource = this.getDrawableConnectionFeedback(event).getDrawableSource();
        Point location = event.getLocation().sub(drawableSource != null ? drawableSource.getContainer().getAbsoluteOffset() : this.getController().getDrawableObject().getAbsoluteOffset());
        switch (anchor) {
            case FROM: {
                if (controller != null) {
                    feedback.setDrawableSource((Drawable)controller.getDrawableObject());
                    controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                    break;
                }
                feedback.setSourceLocation(location);
                break;
            }
            case TO: {
                if (controller != null) {
                    feedback.setDrawableTarget((Drawable)controller.getDrawableObject());
                    controller.getDomain().getCanvas().setCursor(Cursor.CROSS_HAIR_CURSOR);
                    break;
                }
                feedback.setTargetLocation(location);
                break;
            }
            default: {
                feedback.setControlPointLocation(location);
            }
        }
    }

    @NotNull
    protected NodeContainerController getController() {
        return (NodeContainerController)super.getController();
    }

    private boolean isSourceDefined(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.DrawableConnectionFeedback feedback = this.getDrawableConnectionFeedback(event);
        return feedback.getDrawableSource() != null;
    }

    private void updateConnectionFeedback(@NotNull CapabilityEvent event) {
        if (this.isSourceDefined(event)) {
            this.getDomain().getCanvas().setCursor(Cursor.COPY_NO_DROP);
            this.update(event, DrawableHelper.TransitionAnchor.TO);
        }
    }

    private AddingSequenceFlowState.DrawableConnectionFeedback getDrawableConnectionFeedback(@NotNull CapabilityEvent event) {
        AddingSequenceFlowState.ControllerConnectionFeedback controller = (AddingSequenceFlowState.ControllerConnectionFeedback)event.getAdding();
        return controller.getDrawableObject();
    }

    private FlowNodeController getValidTarget(@NotNull CapabilityEvent event, DrawableHelper.TransitionAnchor anchor) {
        HighlightSubcontroller highlight;
        FlowNodeController controller;
        FlowNodeController flowNodeController = controller = event.getTarget() instanceof FlowNodeController ? (FlowNodeController)event.getTarget() : null;
        if (controller == null && event.getTarget() instanceof HighlightSubcontroller && (highlight = (HighlightSubcontroller)event.getTarget()).getContainer() instanceof FlowNodeController) {
            controller = (FlowNodeController)highlight.getContainer();
        }
        if (controller != null) {
            switch (anchor) {
                case FROM: {
                    if (SequenceFlowPolicies.isValidNewSequenceFlowSource(controller.getModelObject())) break;
                    controller = null;
                    break;
                }
                case TO: {
                    AddingSequenceFlowState.DrawableConnectionFeedback connection = this.getDrawableConnectionFeedback(event);
                    FlowNode source = (FlowNode)connection.getDrawableSource().getModelObject();
                    Object target = controller.getModelObject();
                    boolean conditional = ((SequenceFlow)connection.getModelObject()).isConditionalFlow();
                    if (SequenceFlowPolicies.isValidNewSequenceFlowSourceAndTarget((FlowNode)source, target, (boolean)conditional)) break;
                    controller = null;
                }
            }
        }
        return controller;
    }
}

