/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.designer.capability.ConnectionVisuals;
import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.capability.ImageFeedback;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.MeasurementController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.add.ImageAddingCapability;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddMeasurementCommand;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class ContainerAddMeasurementCapability
extends ImageAddingCapability {
    private ConnectionVisuals updater = this.createConnectionVisuals();

    public ContainerAddMeasurementCapability(@NotNull NodeContainerController container) {
        this(CapabilityType.ADD_MEASUREMENT, container);
    }

    protected ContainerAddMeasurementCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.cancelAnyVisuals(event);
    }

    protected void updateAdd(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updateTarget(destination, event);
        super.updateAdd(feedback, destination, event);
    }

    protected void endAdd(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updater.resetCurrentTarget();
        super.endAdd(feedback, destination, event);
    }

    protected ConnectionVisuals createConnectionVisuals() {
        return new ConnectionVisuals(false);
    }

    @NotNull
    protected DrawableFeedback createFeedbackImage(CapabilityEvent event) {
        FlowElementController controller = this.getAddingControllerFromEvent(event);
        controller.refresh();
        DrawableFlowElement drawable = controller.getDrawableObject();
        return ImageFeedback.create(drawable);
    }

    protected Command process(@NotNull Point destination, @NotNull CapabilityEvent event) {
        this.updateTarget(destination, event);
        SequenceFlow target = event.getTarget() instanceof SequenceFlowController ? (SequenceFlow)((SequenceFlowController)event.getTarget()).getModelObject() : null;
        AddMeasurementCommand result = null;
        if (target != null) {
            MeasurementController measurementController = this.getMeasurementControllerFromEvent(event);
            Measurement measurement = (Measurement)measurementController.getModelObject();
            if (!measurement.getParentObject().equals(this.getController().getModelObject())) {
                FlowFigureType type = FlowFigureUtils.fromElement((FlowElement)measurement);
                measurement = (Measurement)FlowFigureUtils.createArtifactFromFigureType((FlowFigureType)type, this.getController().getModelObject());
            }
            Point location = event.getLocation();
            Point drawableLocation = this.getController().getDrawableObject().getAbsoluteOffset();
            location = location.sub(drawableLocation);
            result = new AddMeasurementCommand(measurement, target, location);
        }
        this.updater.resetCurrentTarget();
        return result;
    }

    @NotNull
    protected NodeContainerController getController() {
        return (NodeContainerController)super.getController();
    }

    private MeasurementController getMeasurementControllerFromEvent(CapabilityEvent event) {
        return (MeasurementController)event.getAdding();
    }

    private FlowElementController getAddingControllerFromEvent(CapabilityEvent event) {
        return (FlowElementController)event.getAdding();
    }

    private void updateTarget(@NotNull Point destination, @NotNull CapabilityEvent event) {
        Controller target = event.getTarget();
        if (!(target instanceof SequenceFlowController)) {
            SequenceFlowController closest = ControllerUtils.getClosestTransition(this.getController(), destination, event.getEvent().isShiftDown(), false);
            event.setTarget((Controller)closest);
        }
        this.updater.updateWithTarget(event);
    }
}

