/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability;

import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ImageFeedback<T extends FlowElement>
extends DrawableFeedback<T>
implements Renderer {
    private Image image;

    private ImageFeedback(@NotNull Drawable<?> container, @NotNull DrawableFlowElement<T> drawable, @NotNull DesignerLayer layer) {
        this(container, drawable, layer, (DiagramContext)drawable.getContext());
    }

    private ImageFeedback(@NotNull Drawable<?> container, @NotNull DrawableFlowElement<T> drawable, @NotNull DesignerLayer layer, @NotNull DiagramContext context) {
        super(container, drawable.getModelObject(), layer);
        this.image = this.createImage(drawable, context);
        this.refresh();
        this.attachRenderer(this);
    }

    public static <T extends FlowElement> ImageFeedback<T> create(@NotNull DrawableFlowElement<T> drawable) {
        return new ImageFeedback<T>(drawable.getContainer(), drawable, DesignerLayer.CAPABILITY);
    }

    public static <T extends FlowElement> ImageFeedback<T> create(@NotNull DrawableFlowElement<T> drawable, @NotNull DiagramContext context) {
        return new ImageFeedback<T>(drawable.getContainer(), drawable, DesignerLayer.CAPABILITY, context);
    }

    public void refresh() {
        if (this.image != null) {
            this.setWidth(this.image.getWidth());
            this.setHeight(this.image.getHeight());
        }
        super.refresh();
    }

    public void render() {
        DrawContext context = this.getContext();
        Rectangle bounds = Rectangle.createAround(context.scale(this.getLocation()), this.getWidth(), this.getHeight());
        Graphics graphics = context.getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(Color.TRANSLUCENT);
        graphics.drawImage(this.image, bounds);
        graphics.setForeground(original);
    }

    private Image createImage(@NotNull DrawableFlowElement<T> drawable, @NotNull DiagramContext context) {
        Graphics graphics = context.getGraphics();
        Rectangle clip = graphics.getClipBounds();
        graphics.setClip(drawable.getBounds().expand(1));
        Image result = DrawableUtils.createImageForDrawable(drawable, (DiagramContext)context);
        graphics.setClip(clip);
        return result;
    }
}

