/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability;

import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class ConnectionVisuals {
    private final boolean reparenting;
    private VisualStatus status = VisualStatus.NO_INSERTION;
    private SequenceFlowController target;

    public ConnectionVisuals(boolean reparenting) {
        this.reparenting = reparenting;
    }

    public void resetCurrentTarget() {
        if (this.target != null) {
            this.paintSequenceFlow(this.target.getDrawableObject(), this.target.getDomain(), VisualStatus.NO_INSERTION.getColor());
        }
        this.status = VisualStatus.NO_INSERTION;
    }

    public void updateWithTarget(@NotNull CapabilityEvent event, @NotNull FlowNode flowNode, boolean relocate) {
        SequenceFlow target = this.updateTarget(event);
        if (target != null) {
            VisualStatus status = ModelUtils.canBeInsertedInTransition((FlowNode)flowNode, (SequenceFlow)target, (boolean)relocate, (boolean)this.reparenting) && !flowNode.getIncomingSequenceFlows().contains(target) && !flowNode.getOutgoingSequenceFlows().contains(target) ? VisualStatus.VALID_INSERTION : VisualStatus.INVALID_INSERTION;
            this.repaintTargetSequenceFlow(status);
        }
    }

    public void updateWithTarget(@NotNull CapabilityEvent event) {
        SequenceFlow target = this.updateTarget(event);
        if (target != null) {
            this.repaintTargetSequenceFlow(VisualStatus.VALID_INSERTION);
        }
    }

    private void updateTarget(@NotNull SequenceFlowController target) {
        if (this.target != null && !this.target.equals(target)) {
            this.resetCurrentTarget();
        }
        this.target = target;
    }

    private void repaintTargetSequenceFlow(@NotNull VisualStatus status) {
        if (this.status != status) {
            this.status = status;
            DrawableSequenceFlow drawable = this.target.getDrawableObject();
            this.paintSequenceFlow(drawable, this.target.getDomain(), this.status.getColor());
        }
    }

    private void paintSequenceFlow(@NotNull DrawableSequenceFlow drawable, @NotNull Domain domain, @NotNull Color color) {
        DiagramContext context = domain.getContext();
        Graphics graphics = context.getGraphics();
        graphics.setAntialiasing(AntialiasingMode.ON);
        context.setGraphics(graphics);
        drawable.setColor(color);
        Point offset = drawable.getContainer().getAbsoluteOffset();
        Rectangle bounds = drawable.getBounds().expand(10).translate(offset);
        domain.getCanvas().paintImmediately(context.scale(bounds));
    }

    private SequenceFlow updateTarget(@NotNull CapabilityEvent event) {
        SequenceFlow result;
        Controller target = event.getTarget();
        if (target == null || !(target instanceof SequenceFlowController)) {
            this.resetCurrentTarget();
            result = null;
        } else {
            SequenceFlowController flow = (SequenceFlowController)event.getTarget();
            this.updateTarget(flow);
            result = (SequenceFlow)flow.getModelObject();
        }
        return result;
    }

    private static enum VisualStatus {
        VALID_INSERTION(Color.BLUE),
        INVALID_INSERTION(Color.RED),
        NO_INSERTION(Color.BLACK);

        private final Color color;

        private VisualStatus(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

